/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.james.protocols.api.AbstractProtocolHandlerChain;
import org.apache.james.protocols.api.WiringException;
import org.apache.james.protocols.smtp.core.DataCmdHandler;
import org.apache.james.protocols.smtp.core.DataLineMessageHookHandler;
import org.apache.james.protocols.smtp.core.ExpnCmdHandler;
import org.apache.james.protocols.smtp.core.HeloCmdHandler;
import org.apache.james.protocols.smtp.core.HelpCmdHandler;
import org.apache.james.protocols.smtp.core.MailCmdHandler;
import org.apache.james.protocols.smtp.core.NoopCmdHandler;
import org.apache.james.protocols.smtp.core.PostmasterAbuseRcptHook;
import org.apache.james.protocols.smtp.core.QuitCmdHandler;
import org.apache.james.protocols.smtp.core.RcptCmdHandler;
import org.apache.james.protocols.smtp.core.ReceivedDataLineFilter;
import org.apache.james.protocols.smtp.core.RsetCmdHandler;
import org.apache.james.protocols.smtp.core.SMTPCommandDispatcherLineHandler;
import org.apache.james.protocols.smtp.core.VrfyCmdHandler;
import org.apache.james.protocols.smtp.core.WelcomeMessageHandler;
import org.apache.james.protocols.smtp.core.esmtp.EhloCmdHandler;
import org.apache.james.protocols.smtp.core.esmtp.MailSizeEsmtpExtension;
import org.apache.james.protocols.smtp.hook.Hook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMTPProtocolHandlerChain
extends AbstractProtocolHandlerChain {
    private final List<Object> defaultHandlers = new ArrayList<Object>();
    private final List<Hook> hooks = new ArrayList<Hook>();
    private final List<Object> handlers = new ArrayList<Object>();

    public SMTPProtocolHandlerChain() throws WiringException {
        this.defaultHandlers.add((Object)new SMTPCommandDispatcherLineHandler());
        this.defaultHandlers.add(new ExpnCmdHandler());
        this.defaultHandlers.add(new EhloCmdHandler());
        this.defaultHandlers.add(new HeloCmdHandler());
        this.defaultHandlers.add(new HelpCmdHandler());
        this.defaultHandlers.add(new MailCmdHandler());
        this.defaultHandlers.add(new NoopCmdHandler());
        this.defaultHandlers.add(new QuitCmdHandler());
        this.defaultHandlers.add(new RcptCmdHandler());
        this.defaultHandlers.add(new RsetCmdHandler());
        this.defaultHandlers.add(new VrfyCmdHandler());
        this.defaultHandlers.add(new DataCmdHandler());
        this.defaultHandlers.add(new MailSizeEsmtpExtension());
        this.defaultHandlers.add(new WelcomeMessageHandler());
        this.defaultHandlers.add(new PostmasterAbuseRcptHook());
        this.defaultHandlers.add(new ReceivedDataLineFilter());
        this.defaultHandlers.add(new DataLineMessageHookHandler());
        this.copy();
        this.wireExtensibleHandlers();
    }

    public final synchronized void addHook(Hook hook) throws WiringException {
        this.addHook(this.hooks.size(), hook);
    }

    public final synchronized void addHook(int index, Hook hook) throws WiringException {
        this.hooks.add(index, hook);
        this.copy();
        this.wireExtensibleHandlers();
    }

    public final synchronized Hook removeHook(int index) throws WiringException {
        Hook hook = this.hooks.remove(index);
        this.handlers.remove(hook);
        this.wireExtensibleHandlers();
        return hook;
    }

    public synchronized int getIndexOfHook(Hook hook) {
        return this.hooks.indexOf(hook);
    }

    protected synchronized List<Object> getHandlers() {
        return Collections.unmodifiableList(this.handlers);
    }

    private void copy() {
        this.handlers.clear();
        this.handlers.addAll(this.defaultHandlers);
        this.handlers.addAll(this.hooks);
    }
}

