/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp;

import java.util.LinkedList;
import java.util.List;
import org.apache.james.protocols.api.RetCodeResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SMTPResponse
implements RetCodeResponse {
    private String retCode = null;
    private List<CharSequence> lines = null;
    private String rawLine = null;
    private boolean endSession = false;

    public SMTPResponse(String code, CharSequence description) {
        if (code == null) {
            throw new IllegalArgumentException("SMTPResponse code can not be null");
        }
        if (description == null) {
            throw new IllegalArgumentException("SMTPResponse description can not be null");
        }
        this.setRetCode(code);
        this.appendLine(description);
        this.rawLine = code + " " + description;
    }

    public SMTPResponse(String rawLine) {
        String[] args = rawLine.split(" ");
        if (args == null || args.length <= 1) {
            throw new IllegalArgumentException("Invalid SMTPResponse format. Format should be [SMTPCode SMTPReply]");
        }
        this.setRetCode(args[0]);
        this.appendLine(new StringBuilder(rawLine.substring(args[0].length() + 1)));
        this.rawLine = rawLine;
    }

    public void appendLine(CharSequence line) {
        if (this.lines == null) {
            this.lines = new LinkedList<CharSequence>();
        }
        this.lines.add(line);
    }

    public String getRetCode() {
        return this.retCode;
    }

    public void setRetCode(String retCode) {
        this.retCode = retCode;
    }

    public List<CharSequence> getLines() {
        return this.lines;
    }

    public String getRawLine() {
        return this.rawLine;
    }

    public boolean isEndSession() {
        return this.endSession;
    }

    public void setEndSession(boolean endSession) {
        this.endSession = endSession;
    }

    public String toString() {
        return this.getRetCode() + " " + this.getLines();
    }
}

