/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.james.protocols.api.CommandHandler;
import org.apache.james.protocols.api.ExtensibleHandler;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.Hook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookResultHook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHookableCmdHandler<Hook extends Hook>
implements CommandHandler<SMTPSession>,
ExtensibleHandler {
    private List<Hook> hooks;
    private List<HookResultHook> rHooks;

    public Response onCommand(SMTPSession session, Request request) {
        String parameters;
        String command = request.getCommand();
        SMTPResponse response = this.doFilterChecks(session, command, parameters = request.getArgument());
        if (response == null) {
            response = this.processHooks(session, command, parameters);
            if (response == null) {
                return this.doCoreCmd(session, command, parameters);
            }
            return response;
        }
        return response;
    }

    private SMTPResponse processHooks(SMTPSession session, String command, String parameters) {
        List<Hook> hooks = this.getHooks();
        if (hooks != null) {
            int count = hooks.size();
            for (int i = 0; i < count; ++i) {
                Hook rawHook = (Hook)hooks.get(i);
                session.getLogger().debug("executing hook " + rawHook.getClass().getName());
                long start = System.currentTimeMillis();
                HookResult hRes = this.callHook(rawHook, session, parameters);
                long executionTime = System.currentTimeMillis() - start;
                if (this.rHooks != null) {
                    for (int i2 = 0; i2 < this.rHooks.size(); ++i2) {
                        HookResultHook rHook = this.rHooks.get(i2);
                        session.getLogger().debug("executing hook " + rHook);
                        hRes = rHook.onHookResult(session, hRes, executionTime, rawHook);
                    }
                }
                if ((hRes.getResult() & 1) == 1) {
                    SMTPResponse response = this.doCoreCmd(session, command, parameters);
                    if ((hRes.getResult() & 0x10) == 16) {
                        response.setEndSession(true);
                    }
                    return response;
                }
                SMTPResponse res = AbstractHookableCmdHandler.calcDefaultSMTPResponse(hRes);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    protected abstract HookResult callHook(Hook var1, SMTPSession var2, String var3);

    public static SMTPResponse calcDefaultSMTPResponse(HookResult result) {
        if (result != null) {
            int rCode = result.getResult();
            String smtpRetCode = result.getSmtpRetCode();
            String smtpDesc = result.getSmtpDescription();
            if ((rCode & 2) == 2) {
                if (smtpRetCode == null) {
                    smtpRetCode = "554";
                }
                if (smtpDesc == null) {
                    smtpDesc = "Email rejected";
                }
                SMTPResponse response = new SMTPResponse(smtpRetCode, smtpDesc);
                if ((rCode & 0x10) == 16) {
                    response.setEndSession(true);
                }
                return response;
            }
            if (rCode == 4) {
                if (smtpRetCode == null) {
                    smtpRetCode = "451";
                }
                if (smtpDesc == null) {
                    smtpDesc = "Temporary problem. Please try again later";
                }
                SMTPResponse response = new SMTPResponse(smtpRetCode, smtpDesc);
                if ((rCode & 0x10) == 16) {
                    response.setEndSession(true);
                }
                return response;
            }
            if ((rCode & 1) == 1) {
                if (smtpRetCode == null) {
                    smtpRetCode = "250";
                }
                if (smtpDesc == null) {
                    smtpDesc = "Command accepted";
                }
                SMTPResponse response = new SMTPResponse(smtpRetCode, smtpDesc);
                if ((rCode & 0x10) == 16) {
                    response.setEndSession(true);
                }
                return response;
            }
            if ((rCode & 0x10) == 16) {
                SMTPResponse response = new SMTPResponse("");
                response.setEndSession(true);
                return response;
            }
            return null;
        }
        return null;
    }

    protected abstract SMTPResponse doFilterChecks(SMTPSession var1, String var2, String var3);

    protected abstract SMTPResponse doCoreCmd(SMTPSession var1, String var2, String var3);

    public List<Class<?>> getMarkerInterfaces() {
        ArrayList classes = new ArrayList(2);
        classes.add(this.getHookInterface());
        classes.add(HookResultHook.class);
        return classes;
    }

    protected abstract Class<Hook> getHookInterface();

    public void wireExtensions(Class interfaceName, List extension) {
        if (this.getHookInterface().equals(interfaceName)) {
            this.hooks = extension;
        } else if (HookResultHook.class.equals((Object)interfaceName)) {
            this.rHooks = extension;
        }
    }

    protected List<Hook> getHooks() {
        return this.hooks;
    }
}

