/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.util.Locale;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.apache.mailet.MailAddress;

public abstract class AbstractSenderAuthIdentifyVerificationRcptHook
implements RcptHook {
    public HookResult doRcpt(SMTPSession session, MailAddress sender, MailAddress rcpt) {
        if (session.getUser() != null) {
            String authUser = session.getUser().toLowerCase(Locale.US);
            MailAddress senderAddress = (MailAddress)session.getState().get("SENDER_ADDRESS");
            String username = null;
            if (senderAddress != null) {
                username = this.useVirtualHosting() ? senderAddress.toString() : senderAddress.getLocalPart();
            }
            if (senderAddress == null || !authUser.equalsIgnoreCase(username) || !this.isLocalDomain(senderAddress.getDomain())) {
                return new HookResult(2, "503", DSNStatus.getStatus(5, "7.1") + " Incorrect Authentication for Specified Email Address");
            }
        }
        return new HookResult(8);
    }

    protected abstract boolean isLocalDomain(String var1);

    protected abstract boolean useVirtualHosting();
}

