/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.james.protocols.api.CommandHandler;
import org.apache.james.protocols.api.ExtensibleHandler;
import org.apache.james.protocols.api.LineHandler;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.WiringException;
import org.apache.james.protocols.smtp.MailEnvelopeImpl;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.DataLineFilter;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.mailet.MailAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataCmdHandler
implements CommandHandler<SMTPSession>,
ExtensibleHandler {
    public static final String MAILENV = "MAILENV";
    private LineHandler<SMTPSession> lineHandler;

    public Response onCommand(SMTPSession session, Request request) {
        String parameters = request.getArgument();
        SMTPResponse response = this.doDATAFilter(session, parameters);
        if (response == null) {
            return this.doDATA(session, parameters);
        }
        return response;
    }

    protected SMTPResponse doDATA(SMTPSession session, String argument) {
        MailEnvelopeImpl env = new MailEnvelopeImpl();
        env.setRecipients(new ArrayList<MailAddress>((Collection)session.getState().get("RCPT_LIST")));
        env.setSender((MailAddress)session.getState().get("SENDER_ADDRESS"));
        session.getState().put(MAILENV, env);
        session.pushLineHandler(this.lineHandler);
        return new SMTPResponse("354", "Ok Send data ending with <CRLF>.<CRLF>");
    }

    public Collection<String> getImplCommands() {
        ArrayList<String> implCommands = new ArrayList<String>();
        implCommands.add("DATA");
        return implCommands;
    }

    public List getMarkerInterfaces() {
        LinkedList<Class<DataLineFilter>> classes = new LinkedList<Class<DataLineFilter>>();
        classes.add(DataLineFilter.class);
        return classes;
    }

    public void wireExtensions(Class interfaceName, List extension) throws WiringException {
        if (DataLineFilter.class.equals((Object)interfaceName)) {
            Object lineHandler = new DataConsumerLineHandler();
            for (int i = extension.size() - 1; i >= 0; --i) {
                lineHandler = new DataLineFilterWrapper((DataLineFilter)extension.get(i), (LineHandler<SMTPSession>)lineHandler);
            }
            this.lineHandler = lineHandler;
        }
    }

    protected SMTPResponse doDATAFilter(SMTPSession session, String argument) {
        if (argument != null && argument.length() > 0) {
            return new SMTPResponse("500", DSNStatus.getStatus(5, "5.4") + " Unexpected argument provided with DATA command");
        }
        if (!session.getState().containsKey("SENDER_ADDRESS")) {
            return new SMTPResponse("503", DSNStatus.getStatus(5, "5.0") + " No sender specified");
        }
        if (!session.getState().containsKey("RCPT_LIST")) {
            return new SMTPResponse("503", DSNStatus.getStatus(5, "5.0") + " No recipients specified");
        }
        return null;
    }

    protected LineHandler<SMTPSession> getLineHandler() {
        return this.lineHandler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DataLineFilterWrapper
    implements LineHandler<SMTPSession> {
        private DataLineFilter filter;
        private LineHandler<SMTPSession> next;

        public DataLineFilterWrapper(DataLineFilter filter, LineHandler<SMTPSession> next) {
            this.filter = filter;
            this.next = next;
        }

        public boolean onLine(SMTPSession session, byte[] line) {
            this.filter.onLine(session, line, this.next);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DataConsumerLineHandler
    implements LineHandler<SMTPSession> {
        public boolean onLine(SMTPSession session, byte[] line) {
            if (line.length == 3 && line[0] == 46) {
                session.popLineHandler();
            }
            return false;
        }
    }
}

