/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.james.protocols.api.ExtensibleHandler;
import org.apache.james.protocols.api.LineHandler;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.WiringException;
import org.apache.james.protocols.smtp.MailEnvelopeImpl;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.core.DataLineFilter;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookResultHook;
import org.apache.james.protocols.smtp.hook.MessageHook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataLineMessageHookHandler
implements DataLineFilter,
ExtensibleHandler {
    private List messageHandlers;
    private List rHooks;

    @Override
    public void onLine(SMTPSession session, byte[] line, LineHandler<SMTPSession> next) {
        MailEnvelopeImpl env = (MailEnvelopeImpl)session.getState().get("MAILENV");
        OutputStream out = env.getMessageOutputStream();
        try {
            if (line.length == 3 && line[0] == 46) {
                out.flush();
                out.close();
                this.processExtensions(session, env);
                session.popLineHandler();
            } else if (line[0] == 46 && line[1] == 46) {
                out.write(line, 1, line.length - 1);
            } else {
                out.write(line);
            }
            out.flush();
        }
        catch (IOException e) {
            SMTPResponse response = new SMTPResponse("451", DSNStatus.getStatus(4, "0.0") + " Error processing message: " + e.getMessage());
            session.getLogger().error("Unknown error occurred while processing DATA.", (Throwable)e);
            session.writeResponse((Response)response);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExtensions(SMTPSession session, MailEnvelopeImpl mail) {
        boolean match = false;
        if (mail != null && this.messageHandlers != null) {
            try {
                int count = this.messageHandlers.size();
                for (int i = 0; i < count; ++i) {
                    SMTPResponse response;
                    MessageHook rawHandler = (MessageHook)this.messageHandlers.get(i);
                    session.getLogger().debug("executing message handler " + rawHandler);
                    long start = System.currentTimeMillis();
                    HookResult hRes = rawHandler.onMessage(session, mail);
                    long executionTime = System.currentTimeMillis() - start;
                    if (this.rHooks != null) {
                        for (int i2 = 0; i2 < this.rHooks.size(); ++i2) {
                            Object rHook = this.rHooks.get(i2);
                            session.getLogger().debug("executing hook " + rHook);
                            hRes = ((HookResultHook)rHook).onHookResult(session, hRes, executionTime, rawHandler);
                        }
                    }
                    if ((response = AbstractHookableCmdHandler.calcDefaultSMTPResponse(hRes)) == null) continue;
                    session.writeResponse((Response)response);
                    match = true;
                    break;
                }
                if (!match) {
                    SMTPResponse response = AbstractHookableCmdHandler.calcDefaultSMTPResponse(new HookResult(2));
                    session.writeResponse((Response)response);
                }
            }
            finally {
                session.resetState();
            }
        }
    }

    public void wireExtensions(Class interfaceName, List extension) throws WiringException {
        if (MessageHook.class.equals((Object)interfaceName)) {
            this.messageHandlers = extension;
            if (this.messageHandlers.size() == 0) {
                throw new WiringException("No messageHandler configured");
            }
        } else if (HookResultHook.class.equals((Object)interfaceName)) {
            this.rHooks = extension;
        }
    }

    public List<Class<?>> getMarkerInterfaces() {
        LinkedList classes = new LinkedList();
        classes.add(MessageHook.class);
        classes.add(HookResultHook.class);
        return classes;
    }
}

