/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HeloHook;
import org.apache.james.protocols.smtp.hook.HookResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeloCmdHandler
extends AbstractHookableCmdHandler<HeloHook> {
    private static final String COMMAND_NAME = "HELO";

    public Collection<String> getImplCommands() {
        ArrayList<String> implCommands = new ArrayList<String>();
        implCommands.add(COMMAND_NAME);
        return implCommands;
    }

    @Override
    protected SMTPResponse doCoreCmd(SMTPSession session, String command, String parameters) {
        session.getConnectionState().put("CURRENT_HELO_MODE", COMMAND_NAME);
        StringBuilder response = new StringBuilder();
        response.append(session.getHelloName()).append(" Hello ").append(parameters).append(" (").append(session.getRemoteHost()).append(" [").append(session.getRemoteIPAddress()).append("])");
        return new SMTPResponse("250", response);
    }

    @Override
    protected SMTPResponse doFilterChecks(SMTPSession session, String command, String parameters) {
        session.resetState();
        if (parameters == null) {
            return new SMTPResponse("501", DSNStatus.getStatus(5, "5.4") + " Domain address required: " + COMMAND_NAME);
        }
        session.getState().put("CURRENT_HELO_NAME", parameters);
        return null;
    }

    @Override
    protected Class<HeloHook> getHookInterface() {
        return HeloHook.class;
    }

    @Override
    protected HookResult callHook(HeloHook rawHook, SMTPSession session, String parameters) {
        return rawHook.doHelo(session, parameters);
    }
}

