/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.RetCodeResponse;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.MailHook;
import org.apache.james.protocols.smtp.hook.MailParametersHook;
import org.apache.mailet.MailAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailCmdHandler
extends AbstractHookableCmdHandler<MailHook> {
    private Map<String, MailParametersHook> paramHooks;

    @Override
    public Response onCommand(SMTPSession session, Request request) {
        Response response = super.onCommand(session, request);
        if (!((RetCodeResponse)response).getRetCode().equals("250")) {
            session.getState().remove("SENDER_ADDRESS");
        }
        return response;
    }

    private SMTPResponse doMAIL(SMTPSession session, String argument) {
        StringBuilder responseBuffer = new StringBuilder();
        MailAddress sender = (MailAddress)session.getState().get("SENDER_ADDRESS");
        responseBuffer.append(DSNStatus.getStatus(2, "1.0")).append(" Sender <");
        if (sender != null) {
            responseBuffer.append(sender);
        }
        responseBuffer.append("> OK");
        return new SMTPResponse("250", responseBuffer);
    }

    public Collection<String> getImplCommands() {
        ArrayList<String> implCommands = new ArrayList<String>();
        implCommands.add("MAIL");
        return implCommands;
    }

    @Override
    protected SMTPResponse doCoreCmd(SMTPSession session, String command, String parameters) {
        return this.doMAIL(session, parameters);
    }

    @Override
    protected SMTPResponse doFilterChecks(SMTPSession session, String command, String parameters) {
        return this.doMAILFilter(session, parameters);
    }

    private SMTPResponse doMAILFilter(SMTPSession session, String argument) {
        String sender = null;
        if (argument != null && argument.indexOf(":") > 0) {
            int colonIndex = argument.indexOf(":");
            sender = argument.substring(colonIndex + 1);
            argument = argument.substring(0, colonIndex);
        }
        if (session.getState().containsKey("SENDER_ADDRESS")) {
            return new SMTPResponse("503", DSNStatus.getStatus(5, "5.0") + " Sender already specified");
        }
        if (!session.getConnectionState().containsKey("CURRENT_HELO_MODE") && session.useHeloEhloEnforcement()) {
            return new SMTPResponse("503", DSNStatus.getStatus(5, "5.0") + " Need HELO or EHLO before MAIL");
        }
        if (argument == null || !argument.toUpperCase(Locale.US).equals("FROM") || sender == null) {
            return new SMTPResponse("501", DSNStatus.getStatus(5, "5.4") + " Usage: MAIL FROM:<sender>");
        }
        int lastChar = (sender = sender.trim()).indexOf(62, sender.indexOf(60));
        if (lastChar > 0 && sender.length() > lastChar + 2 && sender.charAt(lastChar + 1) == ' ') {
            String mailOptionString = sender.substring(lastChar + 2);
            sender = sender.substring(0, lastChar + 1);
            StringTokenizer optionTokenizer = new StringTokenizer(mailOptionString, " ");
            while (optionTokenizer.hasMoreElements()) {
                String mailOption = optionTokenizer.nextToken();
                int equalIndex = mailOption.indexOf(61);
                String mailOptionName = mailOption;
                String mailOptionValue = "";
                if (equalIndex > 0) {
                    mailOptionName = mailOption.substring(0, equalIndex).toUpperCase(Locale.US);
                    mailOptionValue = mailOption.substring(equalIndex + 1);
                }
                if (this.paramHooks.containsKey(mailOptionName)) {
                    MailParametersHook hook = this.paramHooks.get(mailOptionName);
                    SMTPResponse res = MailCmdHandler.calcDefaultSMTPResponse(hook.doMailParameter(session, mailOptionName, mailOptionValue));
                    if (res == null) continue;
                    return res;
                }
                if (!session.getLogger().isDebugEnabled()) continue;
                StringBuilder debugBuffer = new StringBuilder(128).append("MAIL command had unrecognized/unexpected option ").append(mailOptionName).append(" with value ").append(mailOptionValue);
                session.getLogger().debug(debugBuffer.toString());
            }
        }
        if (!(!session.useAddressBracketsEnforcement() || sender.startsWith("<") && sender.endsWith(">"))) {
            if (session.getLogger().isInfoEnabled()) {
                StringBuilder errorBuffer = new StringBuilder(128).append("Error parsing sender address: ").append(sender).append(": did not start and end with < >");
                session.getLogger().info(errorBuffer.toString());
            }
            return new SMTPResponse("501", DSNStatus.getStatus(5, "1.7") + " Syntax error in MAIL command");
        }
        MailAddress senderAddress = null;
        if (session.useAddressBracketsEnforcement() || sender.startsWith("<") && sender.endsWith(">")) {
            sender = sender.substring(1, sender.length() - 1);
        }
        if (sender.length() != 0) {
            if (sender.indexOf("@") < 0) {
                sender = sender + "@" + this.getDefaultDomain();
            }
            try {
                senderAddress = new MailAddress(sender);
            }
            catch (Exception pe) {
                if (session.getLogger().isInfoEnabled()) {
                    StringBuilder errorBuffer = new StringBuilder(256).append("Error parsing sender address: ").append(sender).append(": ").append(pe.getMessage());
                    session.getLogger().info(errorBuffer.toString());
                }
                return new SMTPResponse("501", DSNStatus.getStatus(5, "1.7") + " Syntax error in sender address");
            }
        }
        session.getState().put("SENDER_ADDRESS", senderAddress);
        return null;
    }

    @Override
    protected Class<MailHook> getHookInterface() {
        return MailHook.class;
    }

    @Override
    protected HookResult callHook(MailHook rawHook, SMTPSession session, String parameters) {
        return rawHook.doMail(session, (MailAddress)session.getState().get("SENDER_ADDRESS"));
    }

    @Override
    public List<Class<?>> getMarkerInterfaces() {
        List<Class<?>> l = super.getMarkerInterfaces();
        l.add(MailParametersHook.class);
        return l;
    }

    @Override
    public void wireExtensions(Class interfaceName, List extension) {
        if (MailParametersHook.class.equals((Object)interfaceName)) {
            this.paramHooks = new HashMap<String, MailParametersHook>();
            for (MailParametersHook hook : extension) {
                String[] params = hook.getMailParamNames();
                for (int k = 0; k < params.length; ++k) {
                    this.paramHooks.put(params[k], hook);
                }
            }
        } else {
            super.wireExtensions(interfaceName, extension);
        }
    }

    protected String getDefaultDomain() {
        return "localhost";
    }
}

