/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.QuitHook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuitCmdHandler
extends AbstractHookableCmdHandler<QuitHook> {
    private static final String COMMAND_NAME = "QUIT";

    private SMTPResponse doQUIT(SMTPSession session, String argument) {
        SMTPResponse ret;
        if (argument == null || argument.length() == 0) {
            StringBuilder response = new StringBuilder();
            response.append(DSNStatus.getStatus(2, "0.0")).append(" ").append(session.getHelloName()).append(" Service closing transmission channel");
            ret = new SMTPResponse("221", response);
        } else {
            ret = new SMTPResponse("500", DSNStatus.getStatus(5, "5.4") + " Unexpected argument provided with QUIT command");
        }
        ret.setEndSession(true);
        return ret;
    }

    public Collection<String> getImplCommands() {
        ArrayList<String> implCommands = new ArrayList<String>();
        implCommands.add(COMMAND_NAME);
        return implCommands;
    }

    @Override
    protected SMTPResponse doCoreCmd(SMTPSession session, String command, String parameters) {
        return this.doQUIT(session, parameters);
    }

    @Override
    protected SMTPResponse doFilterChecks(SMTPSession session, String command, String parameters) {
        return null;
    }

    @Override
    protected Class<QuitHook> getHookInterface() {
        return QuitHook.class;
    }

    @Override
    protected HookResult callHook(QuitHook rawHook, SMTPSession session, String parameters) {
        return rawHook.doQuit(session);
    }
}

