/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.james.protocols.api.CommandHandler;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.apache.mailet.MailAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RcptCmdHandler
extends AbstractHookableCmdHandler<RcptHook>
implements CommandHandler<SMTPSession> {
    public static final String CURRENT_RECIPIENT = "CURRENT_RECIPIENT";

    @Override
    protected SMTPResponse doCoreCmd(SMTPSession session, String command, String parameters) {
        ArrayList<MailAddress> rcptColl = (ArrayList<MailAddress>)session.getState().get("RCPT_LIST");
        if (rcptColl == null) {
            rcptColl = new ArrayList<MailAddress>();
        }
        MailAddress recipientAddress = (MailAddress)session.getState().get(CURRENT_RECIPIENT);
        rcptColl.add(recipientAddress);
        session.getState().put("RCPT_LIST", rcptColl);
        StringBuilder response = new StringBuilder();
        response.append(DSNStatus.getStatus(2, "1.5")).append(" Recipient <").append(recipientAddress).append("> OK");
        return new SMTPResponse("250", response);
    }

    @Override
    protected SMTPResponse doFilterChecks(SMTPSession session, String command, String argument) {
        String recipient = null;
        if (argument != null && argument.indexOf(":") > 0) {
            int colonIndex = argument.indexOf(":");
            recipient = argument.substring(colonIndex + 1);
            argument = argument.substring(0, colonIndex);
        }
        if (!session.getState().containsKey("SENDER_ADDRESS")) {
            return new SMTPResponse("503", DSNStatus.getStatus(5, "5.0") + " Need MAIL before RCPT");
        }
        if (argument == null || !argument.toUpperCase(Locale.US).equals("TO") || recipient == null) {
            return new SMTPResponse("501", DSNStatus.getStatus(5, "5.2") + " Usage: RCPT TO:<recipient>");
        }
        recipient = recipient.trim();
        int lastChar = recipient.lastIndexOf(62);
        String rcptOptionString = null;
        if (lastChar > 0 && recipient.length() > lastChar + 2 && recipient.charAt(lastChar + 1) == ' ') {
            rcptOptionString = recipient.substring(lastChar + 2);
            recipient = recipient.substring(0, lastChar + 1);
        }
        if (!(!session.useAddressBracketsEnforcement() || recipient.startsWith("<") && recipient.endsWith(">"))) {
            if (session.getLogger().isInfoEnabled()) {
                StringBuilder errorBuffer = new StringBuilder(192).append("Error parsing recipient address: ").append("Address did not start and end with < >").append(this.getContext(session, null, recipient));
                session.getLogger().info(errorBuffer.toString());
            }
            return new SMTPResponse("501", DSNStatus.getStatus(5, "5.2") + " Syntax error in parameters or arguments");
        }
        MailAddress recipientAddress = null;
        if (session.useAddressBracketsEnforcement() || recipient.startsWith("<") && recipient.endsWith(">")) {
            recipient = recipient.substring(1, recipient.length() - 1);
        }
        if (recipient.indexOf("@") < 0) {
            recipient = recipient + "@" + this.getDefaultDomain();
        }
        try {
            recipientAddress = new MailAddress(recipient);
        }
        catch (Exception pe) {
            if (session.getLogger().isInfoEnabled()) {
                StringBuilder errorBuffer = new StringBuilder(192).append("Error parsing recipient address: ").append(this.getContext(session, recipientAddress, recipient)).append(pe.getMessage());
                session.getLogger().info(errorBuffer.toString());
            }
            return new SMTPResponse("553", DSNStatus.getStatus(5, "1.3") + " Syntax error in recipient address");
        }
        if (rcptOptionString != null) {
            StringTokenizer optionTokenizer = new StringTokenizer(rcptOptionString, " ");
            if (optionTokenizer.hasMoreElements()) {
                String rcptOption = optionTokenizer.nextToken();
                int equalIndex = rcptOption.indexOf(61);
                String rcptOptionName = rcptOption;
                String rcptOptionValue = "";
                if (equalIndex > 0) {
                    rcptOptionName = rcptOption.substring(0, equalIndex).toUpperCase(Locale.US);
                    rcptOptionValue = rcptOption.substring(equalIndex + 1);
                }
                if (session.getLogger().isDebugEnabled()) {
                    StringBuilder debugBuffer = new StringBuilder(128).append("RCPT command had unrecognized/unexpected option ").append(rcptOptionName).append(" with value ").append(rcptOptionValue).append(this.getContext(session, recipientAddress, recipient));
                    session.getLogger().debug(debugBuffer.toString());
                }
                return new SMTPResponse("504", "Unrecognized or unsupported option: " + rcptOptionName);
            }
            optionTokenizer = null;
        }
        session.getState().put(CURRENT_RECIPIENT, recipientAddress);
        return null;
    }

    private String getContext(SMTPSession session, MailAddress recipientAddress, String recipient) {
        StringBuilder sb = new StringBuilder(128);
        if (null != recipientAddress) {
            sb.append(" [to:" + recipientAddress.toInternetAddress().getAddress() + "]");
        } else if (null != recipient) {
            sb.append(" [to:" + recipient + "]");
        }
        if (null != session.getState().get("SENDER_ADDRESS")) {
            sb.append(" [from:" + ((MailAddress)session.getState().get("SENDER_ADDRESS")).toInternetAddress().getAddress() + "]");
        }
        return sb.toString();
    }

    public Collection<String> getImplCommands() {
        ArrayList<String> implCommands = new ArrayList<String>();
        implCommands.add("RCPT");
        return implCommands;
    }

    @Override
    protected Class<RcptHook> getHookInterface() {
        return RcptHook.class;
    }

    @Override
    protected HookResult callHook(RcptHook rawHook, SMTPSession session, String parameters) {
        return rawHook.doRcpt(session, (MailAddress)session.getState().get("SENDER_ADDRESS"), (MailAddress)session.getState().get(CURRENT_RECIPIENT));
    }

    protected String getDefaultDomain() {
        return "localhost";
    }
}

