/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.james.protocols.api.LineHandler;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.DataLineFilter;
import org.apache.mailet.base.RFC822DateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceivedDataLineFilter
implements DataLineFilter {
    private static final String SOFTWARE_TYPE = "JAMES SMTP Server ";
    private static final RFC822DateFormat rfc822DateFormat = new RFC822DateFormat();
    private static final String HEADERS_WRITTEN = "HEADERS_WRITTEN";

    @Override
    public void onLine(SMTPSession session, byte[] line, LineHandler<SMTPSession> next) {
        if (!session.getState().containsKey(HEADERS_WRITTEN)) {
            this.addNewReceivedMailHeaders(session, next);
            session.getState().put(HEADERS_WRITTEN, true);
        }
        next.onLine((ProtocolSession)session, line);
    }

    private void addNewReceivedMailHeaders(SMTPSession session, LineHandler<SMTPSession> next) {
        StringBuilder headerLineBuffer = new StringBuilder();
        String heloMode = (String)session.getConnectionState().get("CURRENT_HELO_MODE");
        String heloName = (String)session.getConnectionState().get("CURRENT_HELO_NAME");
        headerLineBuffer.append("Received: from ").append(session.getRemoteHost());
        if (heloName != null) {
            headerLineBuffer.append(" (").append(heloMode).append(" ").append(heloName).append(") ");
        }
        headerLineBuffer.append(" ([").append(session.getRemoteIPAddress()).append("])").append("\r\n");
        try {
            next.onLine((ProtocolSession)session, headerLineBuffer.toString().getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        headerLineBuffer.delete(0, headerLineBuffer.length());
        headerLineBuffer.append("          by ").append(session.getHelloName()).append(" (").append(SOFTWARE_TYPE).append(") with ");
        if ("EHLO".equals(heloMode)) {
            if (session.getUser() == null) {
                headerLineBuffer.append("ESMTP");
            } else {
                headerLineBuffer.append("ESMTPA");
            }
        } else {
            headerLineBuffer.append("SMTP");
        }
        headerLineBuffer.append(" ID ").append(session.getSessionID());
        try {
            if (((Collection)session.getState().get("RCPT_LIST")).size() == 1) {
                headerLineBuffer.append("\r\n");
                next.onLine((ProtocolSession)session, headerLineBuffer.toString().getBytes("US-ASCII"));
                headerLineBuffer.delete(0, headerLineBuffer.length());
                headerLineBuffer.delete(0, headerLineBuffer.length());
                headerLineBuffer.append("          for <").append(((List)session.getState().get("RCPT_LIST")).get(0).toString()).append(">;").append("\r\n");
                next.onLine((ProtocolSession)session, headerLineBuffer.toString().getBytes("US-ASCII"));
                headerLineBuffer.delete(0, headerLineBuffer.length());
                headerLineBuffer.delete(0, headerLineBuffer.length());
            } else {
                headerLineBuffer.append(";");
                headerLineBuffer.append("\r\n");
                next.onLine((ProtocolSession)session, headerLineBuffer.toString().getBytes("US-ASCII"));
                headerLineBuffer.delete(0, headerLineBuffer.length());
            }
            headerLineBuffer = null;
            next.onLine((ProtocolSession)session, ("          " + rfc822DateFormat.format(new Date()) + "\r\n").getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

