/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.util.Date;
import org.apache.james.protocols.api.ConnectHandler;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.mailet.base.RFC822DateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WelcomeMessageHandler
implements ConnectHandler<SMTPSession> {
    private static final RFC822DateFormat rfc822DateFormat = new RFC822DateFormat();

    public boolean onConnect(SMTPSession session) {
        String smtpGreeting = session.getSMTPGreeting();
        SMTPResponse welcomeResponse = smtpGreeting == null ? new SMTPResponse("220", new StringBuilder(256).append(session.getHelloName()).append(" SMTP Server (").append(this.getProductName()).append(") ready ").append(rfc822DateFormat.format(new Date()))) : new SMTPResponse("220", smtpGreeting);
        session.writeResponse((Response)welcomeResponse);
        return false;
    }

    protected String getProductName() {
        return "JAMES SMTP Server";
    }
}

