/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.esmtp;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;
import org.apache.james.protocols.api.CommandHandler;
import org.apache.james.protocols.api.ExtensibleHandler;
import org.apache.james.protocols.api.LineHandler;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.WiringException;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.esmtp.EhloExtension;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.AuthHook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookResultHook;
import org.apache.james.protocols.smtp.hook.MailParametersHook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthCmdHandler
implements CommandHandler<SMTPSession>,
EhloExtension,
ExtensibleHandler,
MailParametersHook {
    private static final String AUTH_TYPE_PLAIN = "PLAIN";
    private static final String AUTH_TYPE_LOGIN = "LOGIN";
    private List<AuthHook> hooks;
    private List rHooks;

    public Response onCommand(SMTPSession session, Request request) {
        return this.doAUTH(session, request.getArgument());
    }

    private SMTPResponse doAUTH(SMTPSession session, String argument) {
        String authType;
        if (session.getUser() != null) {
            return new SMTPResponse("503", DSNStatus.getStatus(5, "5.0") + " User has previously authenticated. " + " Further authentication is not required!");
        }
        if (argument == null) {
            return new SMTPResponse("501", DSNStatus.getStatus(5, "5.4") + " Usage: AUTH (authentication type) <challenge>");
        }
        String initialResponse = null;
        if (argument != null && argument.indexOf(" ") > 0) {
            initialResponse = argument.substring(argument.indexOf(" ") + 1);
            argument = argument.substring(0, argument.indexOf(" "));
        }
        if ((authType = argument.toUpperCase(Locale.US)).equals(AUTH_TYPE_PLAIN)) {
            if (initialResponse == null) {
                session.pushLineHandler(new AbstractSMTPLineHandler(){

                    protected SMTPResponse onCommand(SMTPSession session, String l) {
                        return AuthCmdHandler.this.doPlainAuthPass(session, l);
                    }
                });
                return new SMTPResponse("334", "OK. Continue authentication");
            }
            String userpass = initialResponse.trim();
            return this.doPlainAuthPass(session, userpass);
        }
        if (authType.equals(AUTH_TYPE_LOGIN)) {
            if (initialResponse == null) {
                session.pushLineHandler(new AbstractSMTPLineHandler(){

                    protected SMTPResponse onCommand(SMTPSession session, String l) {
                        return AuthCmdHandler.this.doLoginAuthPass(session, l);
                    }
                });
                return new SMTPResponse("334", "VXNlcm5hbWU6");
            }
            String user = initialResponse.trim();
            return this.doLoginAuthPass(session, user);
        }
        return this.doUnknownAuth(session, authType, initialResponse);
    }

    private SMTPResponse doPlainAuthPass(SMTPSession session, String userpass) {
        String pass;
        String user;
        block5: {
            user = null;
            pass = null;
            try {
                if (userpass != null) {
                    userpass = new String(Base64.decodeBase64((String)userpass));
                }
                if (userpass == null) break block5;
                StringTokenizer authTokenizer = new StringTokenizer(userpass, "\u0000");
                String authorize_id = authTokenizer.nextToken();
                user = authTokenizer.nextToken();
                try {
                    pass = authTokenizer.nextToken();
                }
                catch (NoSuchElementException _) {
                    pass = user;
                    user = authorize_id;
                }
                authTokenizer = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        SMTPResponse response = this.doAuthTest(session, user, pass, AUTH_TYPE_PLAIN);
        session.popLineHandler();
        return response;
    }

    private SMTPResponse doLoginAuthPass(SMTPSession session, String user) {
        if (user != null) {
            try {
                user = new String(Base64.decodeBase64((String)user));
            }
            catch (Exception e) {
                user = null;
            }
        }
        session.popLineHandler();
        session.pushLineHandler(new AbstractSMTPLineHandler(){
            private String user;

            public LineHandler<SMTPSession> setUser(String user) {
                this.user = user;
                return this;
            }

            @Override
            protected SMTPResponse onCommand(SMTPSession session, String l) {
                return AuthCmdHandler.this.doLoginAuthPassCheck(session, this.user, l);
            }
        }.setUser(user));
        return new SMTPResponse("334", "UGFzc3dvcmQ6");
    }

    private SMTPResponse doLoginAuthPassCheck(SMTPSession session, String user, String pass) {
        if (pass != null) {
            try {
                pass = new String(Base64.decodeBase64((String)pass));
            }
            catch (Exception e) {
                pass = null;
            }
        }
        session.popLineHandler();
        SMTPResponse response = this.doAuthTest(session, user, pass, AUTH_TYPE_LOGIN);
        return response;
    }

    private SMTPResponse doAuthTest(SMTPSession session, String user, String pass, String authType) {
        if (user == null || pass == null) {
            return new SMTPResponse("501", "Could not decode parameters for AUTH " + authType);
        }
        SMTPResponse res = null;
        List<AuthHook> hooks = this.getHooks();
        if (hooks != null) {
            int count = hooks.size();
            for (int i = 0; i < count; ++i) {
                AuthHook rawHook = hooks.get(i);
                session.getLogger().debug("executing  hook " + rawHook);
                long start = System.currentTimeMillis();
                HookResult hRes = rawHook.doAuth(session, user, pass);
                long executionTime = System.currentTimeMillis() - start;
                if (this.rHooks != null) {
                    for (int i2 = 0; i2 < this.rHooks.size(); ++i2) {
                        Object rHook = this.rHooks.get(i2);
                        session.getLogger().debug("executing  hook " + rHook);
                        hRes = ((HookResultHook)rHook).onHookResult(session, hRes, executionTime, rawHook);
                    }
                }
                if ((res = this.calcDefaultSMTPResponse(hRes)) == null) continue;
                if ("535".equals(res.getRetCode())) {
                    session.getLogger().error("AUTH method " + authType + " failed");
                } else if ("235".equals(res.getRetCode()) && session.getLogger().isDebugEnabled()) {
                    session.getLogger().debug("AUTH method " + authType + " succeeded");
                }
                return res;
            }
        }
        res = new SMTPResponse("535", "Authentication Failed");
        session.getLogger().error("AUTH method " + authType + " failed");
        return res;
    }

    protected SMTPResponse calcDefaultSMTPResponse(HookResult result) {
        if (result != null) {
            int rCode = result.getResult();
            String smtpRetCode = result.getSmtpRetCode();
            String smtpDesc = result.getSmtpDescription();
            if ((rCode & 2) == 2) {
                if (smtpRetCode == null) {
                    smtpRetCode = "535";
                }
                if (smtpDesc == null) {
                    smtpDesc = "Authentication Failed";
                }
                SMTPResponse response = new SMTPResponse(smtpRetCode, smtpDesc);
                if ((rCode & 0x10) == 16) {
                    response.setEndSession(true);
                }
                return response;
            }
            if ((rCode & 4) == 4) {
                if (smtpRetCode == null) {
                    smtpRetCode = "451";
                }
                if (smtpDesc == null) {
                    smtpDesc = "Temporary problem. Please try again later";
                }
                SMTPResponse response = new SMTPResponse(smtpRetCode, smtpDesc);
                if ((rCode & 0x10) == 16) {
                    response.setEndSession(true);
                }
                return response;
            }
            if ((rCode & 1) == 1) {
                if (smtpRetCode == null) {
                    smtpRetCode = "235";
                }
                if (smtpDesc == null) {
                    smtpDesc = "Authentication Succesfull";
                }
                SMTPResponse response = new SMTPResponse(smtpRetCode, smtpDesc);
                if ((rCode & 0x10) == 16) {
                    response.setEndSession(true);
                }
                return response;
            }
            if ((rCode & 0x10) == 16) {
                SMTPResponse response = new SMTPResponse("");
                response.setEndSession(true);
                return response;
            }
            return null;
        }
        return null;
    }

    private SMTPResponse doUnknownAuth(SMTPSession session, String authType, String initialResponse) {
        if (session.getLogger().isInfoEnabled()) {
            StringBuilder errorBuffer = new StringBuilder(128).append("AUTH method ").append(authType).append(" is an unrecognized authentication type");
            session.getLogger().info(errorBuffer.toString());
        }
        return new SMTPResponse("504", "Unrecognized Authentication Type");
    }

    public Collection<String> getImplCommands() {
        ArrayList<String> implCommands = new ArrayList<String>();
        implCommands.add("AUTH");
        return implCommands;
    }

    @Override
    public List<String> getImplementedEsmtpFeatures(SMTPSession session) {
        if (session.isAuthSupported()) {
            LinkedList<String> resp = new LinkedList<String>();
            resp.add("AUTH LOGIN PLAIN");
            resp.add("AUTH=LOGIN PLAIN");
            return resp;
        }
        return null;
    }

    public List<Class<?>> getMarkerInterfaces() {
        ArrayList classes = new ArrayList(1);
        classes.add(AuthHook.class);
        return classes;
    }

    public void wireExtensions(Class interfaceName, List extension) throws WiringException {
        if (AuthHook.class.equals((Object)interfaceName)) {
            this.hooks = extension;
            if (this.hooks == null || this.hooks.size() == 0) {
                throw new WiringException("AuthCmdHandler used without AuthHooks");
            }
        } else if (HookResultHook.class.equals((Object)interfaceName)) {
            this.rHooks = extension;
        }
    }

    protected List<AuthHook> getHooks() {
        return this.hooks;
    }

    @Override
    public HookResult doMailParameter(SMTPSession session, String paramName, String paramValue) {
        return new HookResult(8);
    }

    @Override
    public String[] getMailParamNames() {
        return new String[]{"AUTH"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractSMTPLineHandler
    implements LineHandler<SMTPSession> {
        private AbstractSMTPLineHandler() {
        }

        public boolean onLine(SMTPSession session, byte[] l) {
            try {
                SMTPResponse res = this.handleCommand(session, new String(l, "US-ASCII"));
                session.writeResponse((Response)res);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return false;
        }

        private SMTPResponse handleCommand(SMTPSession session, String line) {
            if (line.equals("*\r\n")) {
                session.popLineHandler();
                return new SMTPResponse("501", DSNStatus.getStatus(5, "7.1") + " Authentication aborted");
            }
            return this.onCommand(session, line);
        }

        protected abstract SMTPResponse onCommand(SMTPSession var1, String var2);
    }
}

