/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.esmtp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.core.esmtp.EhloExtension;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HeloHook;
import org.apache.james.protocols.smtp.hook.HookResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhloCmdHandler
extends AbstractHookableCmdHandler<HeloHook> {
    private static final String COMMAND_NAME = "EHLO";
    private List<EhloExtension> ehloExtensions;

    private SMTPResponse doEHLO(SMTPSession session, String argument) {
        SMTPResponse resp = new SMTPResponse("250", new StringBuilder(session.getHelloName()).append(" Hello ").append(argument).append(" (").append(session.getRemoteHost()).append(" [").append(session.getRemoteIPAddress()).append("])"));
        session.getConnectionState().put("CURRENT_HELO_MODE", COMMAND_NAME);
        this.processExtensions(session, resp);
        resp.appendLine("PIPELINING");
        resp.appendLine("ENHANCEDSTATUSCODES");
        resp.appendLine("8BITMIME");
        return resp;
    }

    public Collection<String> getImplCommands() {
        ArrayList<String> implCommands = new ArrayList<String>();
        implCommands.add(COMMAND_NAME);
        return implCommands;
    }

    @Override
    public List<Class<?>> getMarkerInterfaces() {
        List<Class<?>> classes = super.getMarkerInterfaces();
        classes.add(EhloExtension.class);
        return classes;
    }

    @Override
    public void wireExtensions(Class interfaceName, List extension) {
        super.wireExtensions(interfaceName, extension);
        if (EhloExtension.class.equals((Object)interfaceName)) {
            this.ehloExtensions = extension;
        }
    }

    private void processExtensions(SMTPSession session, SMTPResponse resp) {
        if (this.ehloExtensions != null) {
            int count = this.ehloExtensions.size();
            for (int i = 0; i < count; ++i) {
                List<String> lines = this.ehloExtensions.get(i).getImplementedEsmtpFeatures(session);
                if (lines == null) continue;
                for (int j = 0; j < lines.size(); ++j) {
                    resp.appendLine(lines.get(j));
                }
            }
        }
    }

    @Override
    protected SMTPResponse doCoreCmd(SMTPSession session, String command, String parameters) {
        return this.doEHLO(session, parameters);
    }

    @Override
    protected SMTPResponse doFilterChecks(SMTPSession session, String command, String parameters) {
        session.resetState();
        if (parameters == null) {
            return new SMTPResponse("501", DSNStatus.getStatus(5, "5.4") + " Domain address required: " + COMMAND_NAME);
        }
        session.getState().put("CURRENT_HELO_NAME", parameters);
        return null;
    }

    @Override
    protected Class<HeloHook> getHookInterface() {
        return HeloHook.class;
    }

    @Override
    protected HookResult callHook(HeloHook rawHook, SMTPSession session, String parameters) {
        return rawHook.doHelo(session, parameters);
    }
}

