/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.esmtp;

import java.util.LinkedList;
import java.util.List;
import org.apache.james.protocols.api.LineHandler;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.MailEnvelope;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.DataLineFilter;
import org.apache.james.protocols.smtp.core.esmtp.EhloExtension;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.MailParametersHook;
import org.apache.james.protocols.smtp.hook.MessageHook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailSizeEsmtpExtension
implements MailParametersHook,
EhloExtension,
DataLineFilter,
MessageHook {
    private static final String MESG_SIZE = "MESG_SIZE";
    private static final String MESG_FAILED = "MESG_FAILED";

    @Override
    public HookResult doMailParameter(SMTPSession session, String paramName, String paramValue) {
        HookResult res = this.doMailSize(session, paramValue, (String)session.getState().get("SENDER_ADDRESS"));
        return res;
    }

    @Override
    public String[] getMailParamNames() {
        return new String[]{"SIZE"};
    }

    @Override
    public List<String> getImplementedEsmtpFeatures(SMTPSession session) {
        LinkedList<String> resp = new LinkedList<String>();
        long maxMessageSize = session.getMaxMessageSize();
        if (maxMessageSize > 0L) {
            resp.add("SIZE " + maxMessageSize);
        }
        return resp;
    }

    private HookResult doMailSize(SMTPSession session, String mailOptionValue, String tempSender) {
        long maxMessageSize;
        int size = 0;
        try {
            size = Integer.parseInt(mailOptionValue);
        }
        catch (NumberFormatException pe) {
            session.getLogger().error("Rejected syntactically incorrect value for SIZE parameter.");
            return new HookResult(2, "501", DSNStatus.getStatus(5, "5.4") + " Syntactically incorrect value for SIZE parameter");
        }
        if (session.getLogger().isDebugEnabled()) {
            StringBuilder debugBuffer = new StringBuilder(128).append("MAIL command option SIZE received with value ").append(size).append(".");
            session.getLogger().debug(debugBuffer.toString());
        }
        if ((maxMessageSize = session.getMaxMessageSize()) > 0L && (long)size > maxMessageSize) {
            StringBuilder errorBuffer = new StringBuilder(256).append("Rejected message from ").append(tempSender != null ? tempSender : null).append(" from host ").append(session.getRemoteHost()).append(" (").append(session.getRemoteIPAddress()).append(") of size ").append(size).append(" exceeding system maximum message size of ").append(maxMessageSize).append("based on SIZE option.");
            session.getLogger().error(errorBuffer.toString());
            return new HookResult(2, "552", DSNStatus.getStatus(5, "3.4") + " Message size exceeds fixed maximum message size");
        }
        session.getState().put(MESG_SIZE, size);
        return null;
    }

    @Override
    public void onLine(SMTPSession session, byte[] line, LineHandler<SMTPSession> next) {
        Boolean failed = (Boolean)session.getState().get(MESG_FAILED);
        if (failed == null || !failed.booleanValue()) {
            if (line.length == 3 && line[0] == 46) {
                next.onLine((ProtocolSession)session, line);
            } else {
                Long currentSize = (Long)session.getState().get("CURRENT_SIZE");
                Long newSize = currentSize == null ? Long.valueOf(line.length) : Long.valueOf(currentSize.intValue() + line.length);
                if (session.getMaxMessageSize() > 0L && (long)newSize.intValue() > session.getMaxMessageSize()) {
                    session.getState().put(MESG_FAILED, Boolean.TRUE);
                    next.onLine((ProtocolSession)session, ".\r\n".getBytes());
                } else {
                    next.onLine((ProtocolSession)session, line);
                }
                session.getState().put("CURRENT_SIZE", newSize);
            }
        }
    }

    @Override
    public HookResult onMessage(SMTPSession session, MailEnvelope mail) {
        Boolean failed = (Boolean)session.getState().get(MESG_FAILED);
        if (failed != null && failed.booleanValue()) {
            HookResult response = new HookResult(2, "552", DSNStatus.getStatus(5, "3.4") + " Maximum message size exceeded");
            StringBuilder errorBuffer = new StringBuilder(256).append("Rejected message from ").append(session.getState().get("SENDER_ADDRESS").toString()).append(" from host ").append(session.getRemoteHost()).append(" (").append(session.getRemoteIPAddress()).append(") exceeding system maximum message size of ").append(session.getMaxMessageSize());
            session.getLogger().error(errorBuffer.toString());
            return response;
        }
        return new HookResult(8);
    }
}

