/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.esmtp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.james.protocols.api.CommandHandler;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.esmtp.EhloExtension;
import org.apache.james.protocols.smtp.dsn.DSNStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartTlsCmdHandler
implements CommandHandler<SMTPSession>,
EhloExtension {
    private static final String COMMAND_NAME = "STARTTLS";

    public Collection<String> getImplCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(COMMAND_NAME);
        return commands;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Response onCommand(SMTPSession session, Request request) {
        String command = request.getCommand();
        String parameters = request.getArgument();
        if (session.isStartTLSSupported()) {
            if (session.isTLSStarted()) {
                return new SMTPResponse("500", DSNStatus.getStatus(5, "5.1") + " TLS already active RFC2487 5.2");
            }
            SMTPResponse response = parameters == null || parameters.length() == 0 ? new SMTPResponse("220", DSNStatus.getStatus(2, "0.0") + " Ready to start TLS") : new SMTPResponse("501 " + DSNStatus.getStatus(5, "5.4") + " Syntax error (no parameters allowed) with STARTTLS command");
            session.writeResponse((Response)response);
            try {
                if (session.isTLSStarted()) return null;
                session.startTLS();
                session.resetState();
                return null;
            }
            catch (IOException e) {
                return new SMTPResponse("451", "TLS not available due to temporary reason");
            }
        } else {
            StringBuilder result = new StringBuilder();
            result.append(DSNStatus.getStatus(5, "5.1")).append(" Command ").append(command).append(" unrecognized.");
            return new SMTPResponse("500", result);
        }
    }

    @Override
    public List<String> getImplementedEsmtpFeatures(SMTPSession session) {
        ArrayList<String> esmtpextensions = new ArrayList<String>();
        if (!session.isTLSStarted() && session.isStartTLSSupported()) {
            esmtpextensions.add(COMMAND_NAME);
        }
        return esmtpextensions;
    }
}

