/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import java.util.Iterator;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.apache.mailet.MailAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGreylistHandler
implements RcptHook {
    private long tempBlockTime = 3600000L;
    private long autoWhiteListLifeTime = 3110400000L;
    private long unseenLifeTime = 14400000L;

    public void setUnseenLifeTime(long unseenLifeTime) {
        this.unseenLifeTime = unseenLifeTime;
    }

    public void setAutoWhiteListLifeTime(long autoWhiteListLifeTime) {
        this.autoWhiteListLifeTime = autoWhiteListLifeTime;
    }

    public void setTempBlockTime(long tempBlockTime) {
        this.tempBlockTime = tempBlockTime;
    }

    private HookResult doGreyListCheck(SMTPSession session, MailAddress senderAddress, MailAddress recipAddress) {
        String recip = "";
        String sender = "";
        if (recipAddress != null) {
            recip = recipAddress.toString();
        }
        if (senderAddress != null) {
            sender = senderAddress.toString();
        }
        long time = System.currentTimeMillis();
        String ipAddress = session.getRemoteIPAddress();
        try {
            long createTimeStamp = 0L;
            int count = 0;
            Iterator<String> data = this.getGreyListData(ipAddress, sender, recip);
            if (data.hasNext()) {
                createTimeStamp = Long.parseLong(data.next());
                count = Integer.parseInt(data.next());
            }
            session.getLogger().debug("Triplet " + ipAddress + " | " + sender + " | " + recip + " -> TimeStamp: " + createTimeStamp);
            if (createTimeStamp > 0L) {
                long acceptTime = createTimeStamp + this.tempBlockTime;
                if (time < acceptTime && count == 0) {
                    return new HookResult(4, "451", DSNStatus.getStatus(4, "4.3") + " Temporary rejected: Reconnect to fast. Please try again later");
                }
            } else {
                session.getLogger().debug("New triplet " + ipAddress + " | " + sender + " | " + recip);
                this.insertTriplet(ipAddress, sender, recip, count, time);
                return new HookResult(4, "451", DSNStatus.getStatus(4, "4.3") + " Temporary rejected: Please try again later");
            }
            session.getLogger().debug("Update triplet " + ipAddress + " | " + sender + " | " + recip + " -> timestamp: " + time);
            this.updateTriplet(ipAddress, sender, recip, count, time);
            if (Math.random() > 0.99) {
                session.getLogger().debug("Delete old entries");
                this.cleanupAutoWhiteListGreyList(time - this.autoWhiteListLifeTime);
                this.cleanupGreyList(time - this.unseenLifeTime);
            }
        }
        catch (Exception e) {
            session.getLogger().error("Error on greylist method: " + e.getMessage());
        }
        return new HookResult(8);
    }

    protected abstract Iterator<String> getGreyListData(String var1, String var2, String var3) throws Exception;

    protected abstract void insertTriplet(String var1, String var2, String var3, int var4, long var5) throws Exception;

    protected abstract void updateTriplet(String var1, String var2, String var3, int var4, long var5) throws Exception;

    protected abstract void cleanupAutoWhiteListGreyList(long var1) throws Exception;

    protected abstract void cleanupGreyList(long var1) throws Exception;

    @Override
    public HookResult doRcpt(SMTPSession session, MailAddress sender, MailAddress rcpt) {
        if (!session.isRelayingAllowed()) {
            return this.doGreyListCheck(session, sender, rcpt);
        }
        session.getLogger().info("IpAddress " + session.getRemoteIPAddress() + " is allowed to send. Skip greylisting.");
        return new HookResult(8);
    }
}

