/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import java.net.UnknownHostException;
import java.util.Collection;
import java.util.StringTokenizer;
import org.apache.james.protocols.api.ConnectHandler;
import org.apache.james.protocols.smtp.DNSService;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.apache.mailet.MailAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNSRBLHandler
implements ConnectHandler<SMTPSession>,
RcptHook {
    private String[] whitelist;
    private String[] blacklist;
    private DNSService dnsService = null;
    private boolean getDetail = false;
    private String blocklistedDetail = null;
    public static final String RBL_BLOCKLISTED_MAIL_ATTRIBUTE_NAME = "org.apache.james.smtpserver.rbl.blocklisted";
    public static final String RBL_DETAIL_MAIL_ATTRIBUTE_NAME = "org.apache.james.smtpserver.rbl.detail";

    public final void setDNSService(DNSService dnsService) {
        this.dnsService = dnsService;
    }

    public boolean onConnect(SMTPSession session) {
        this.checkDNSRBL(session, session.getRemoteIPAddress());
        return false;
    }

    public void setWhitelist(String[] whitelist) {
        if (whitelist != null) {
            this.whitelist = new String[whitelist.length];
            for (int i = 0; i < whitelist.length; ++i) {
                this.whitelist[i] = new String(whitelist[i]);
            }
        }
        this.whitelist = whitelist;
    }

    public void setBlacklist(String[] blacklist) {
        if (blacklist != null) {
            this.blacklist = new String[blacklist.length];
            for (int i = 0; i < blacklist.length; ++i) {
                this.blacklist[i] = new String(blacklist[i]);
            }
        }
    }

    public void setGetDetail(boolean getDetail) {
        this.getDetail = getDetail;
    }

    public void checkDNSRBL(SMTPSession session, String ipAddress) {
        if (session.isRelayingAllowed()) {
            session.getLogger().info("Ipaddress " + session.getRemoteIPAddress() + " is allowed to relay. Don't check it");
            return;
        }
        if (this.whitelist != null || this.blacklist != null) {
            int i;
            String[] rblList;
            StringBuffer sb = new StringBuffer();
            StringTokenizer st = new StringTokenizer(ipAddress, " .", false);
            while (st.hasMoreTokens()) {
                sb.insert(0, st.nextToken() + ".");
            }
            String reversedOctets = sb.toString();
            if (this.whitelist != null) {
                rblList = this.whitelist;
                for (i = 0; i < rblList.length; ++i) {
                    try {
                        this.dnsService.getByName(reversedOctets + rblList[i]);
                        if (session.getLogger().isInfoEnabled()) {
                            session.getLogger().info("Connection from " + ipAddress + " whitelisted by " + rblList[i]);
                        }
                        return;
                    }
                    catch (UnknownHostException uhe) {
                        if (!session.getLogger().isDebugEnabled()) continue;
                        session.getLogger().debug("IpAddress " + session.getRemoteIPAddress() + " not listed on " + rblList[i]);
                        continue;
                    }
                }
            }
            if (this.blacklist != null) {
                rblList = this.blacklist;
                for (i = 0; i < rblList.length; ++i) {
                    try {
                        Collection<String> txt;
                        this.dnsService.getByName(reversedOctets + rblList[i]);
                        if (session.getLogger().isInfoEnabled()) {
                            session.getLogger().info("Connection from " + ipAddress + " restricted by " + rblList[i] + " to SMTP AUTH/postmaster/abuse.");
                        }
                        if (this.getDetail && !(txt = this.dnsService.findTXTRecords(reversedOctets + rblList[i])).isEmpty()) {
                            String blocklistedDetail = txt.iterator().next().toString();
                            session.getConnectionState().put(RBL_DETAIL_MAIL_ATTRIBUTE_NAME, blocklistedDetail);
                        }
                        session.getConnectionState().put(RBL_BLOCKLISTED_MAIL_ATTRIBUTE_NAME, "true");
                        return;
                    }
                    catch (UnknownHostException uhe) {
                        if (!session.getLogger().isDebugEnabled()) continue;
                        session.getLogger().debug("unknown host exception thrown:" + rblList[i]);
                        continue;
                    }
                }
            }
        }
    }

    @Override
    public HookResult doRcpt(SMTPSession session, MailAddress sender, MailAddress rcpt) {
        String blocklisted;
        if (!session.isRelayingAllowed() && (blocklisted = (String)session.getConnectionState().get(RBL_BLOCKLISTED_MAIL_ATTRIBUTE_NAME)) != null) {
            if (this.blocklistedDetail == null) {
                return new HookResult(2, DSNStatus.getStatus(5, "7.1") + " Rejected: unauthenticated e-mail from " + session.getRemoteIPAddress() + " is restricted.  Contact the postmaster for details.");
            }
            return new HookResult(2, DSNStatus.getStatus(5, "7.1") + " " + this.blocklistedDetail);
        }
        return new HookResult(8);
    }
}

