/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.apache.mailet.MailAddress;

public class MaxRcptHandler
implements RcptHook {
    private int maxRcpt = 0;

    public void setMaxRcpt(int maxRcpt) {
        this.maxRcpt = maxRcpt;
    }

    public HookResult doRcpt(SMTPSession session, MailAddress sender, MailAddress rcpt) {
        if (session.getRcptCount() + 1 > this.maxRcpt) {
            session.getLogger().info("Maximum recipients of " + this.maxRcpt + " reached");
            return new HookResult(2, "452", DSNStatus.getStatus(4, "5.3") + " Requested action not taken: max recipients reached");
        }
        return new HookResult(8);
    }
}

