/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import java.net.UnknownHostException;
import org.apache.james.protocols.smtp.DNSService;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HeloHook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.apache.mailet.MailAddress;

public class ResolvableEhloHeloHandler
implements RcptHook,
HeloHook {
    public static final String BAD_EHLO_HELO = "BAD_EHLO_HELO";
    protected DNSService dnsService = null;

    public final DNSService getDNSService() {
        return this.dnsService;
    }

    public final void setDNSService(DNSService dnsService) {
        this.dnsService = dnsService;
    }

    protected void checkEhloHelo(SMTPSession session, String argument) {
        if (this.isBadHelo(session, argument)) {
            session.getState().put(BAD_EHLO_HELO, "true");
        }
    }

    protected boolean isBadHelo(SMTPSession session, String argument) {
        try {
            this.dnsService.getByName(argument);
        }
        catch (UnknownHostException e) {
            return true;
        }
        return false;
    }

    protected boolean check(SMTPSession session, MailAddress rcpt) {
        return session.getState().get(BAD_EHLO_HELO) != null;
    }

    public HookResult doRcpt(SMTPSession session, MailAddress sender, MailAddress rcpt) {
        if (this.check(session, rcpt)) {
            return new HookResult(2, "501", DSNStatus.getStatus(5, "5.4") + " Provided EHLO/HELO " + session.getState().get("CURRENT_HELO_NAME") + " can not resolved.");
        }
        return new HookResult(8);
    }

    public HookResult doHelo(SMTPSession session, String helo) {
        this.checkEhloHelo(session, helo);
        return new HookResult(8);
    }
}

