/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import java.util.Collection;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.apache.mailet.MailAddress;

public class SupressDuplicateRcptHandler
implements RcptHook {
    public HookResult doRcpt(SMTPSession session, MailAddress sender, MailAddress rcpt) {
        Collection rcptList = (Collection)session.getState().get("RCPT_LIST");
        if (rcptList != null && rcptList.contains(rcpt)) {
            StringBuilder responseBuffer = new StringBuilder();
            responseBuffer.append(DSNStatus.getStatus(2, "1.5")).append(" Recipient <").append(rcpt.toString()).append("> OK");
            session.getLogger().debug("Duplicate recipient not add to recipient list: " + rcpt.toString());
            return new HookResult(1, "250", responseBuffer.toString());
        }
        return new HookResult(8);
    }
}

