/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core.fastfail;

import java.util.Collection;
import org.apache.james.protocols.smtp.DNSService;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.TemporaryResolutionException;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.MailHook;
import org.apache.mailet.MailAddress;

public class ValidSenderDomainHandler
implements MailHook {
    private DNSService dnsService = null;

    public final void setDNSService(DNSService dnsService) {
        this.dnsService = dnsService;
    }

    protected boolean check(SMTPSession session, MailAddress senderAddress) {
        if (senderAddress == null) {
            return false;
        }
        Collection<String> records = null;
        try {
            records = this.dnsService.findMXRecords(senderAddress.getDomain());
        }
        catch (TemporaryResolutionException e) {
            // empty catch block
        }
        return records == null || records.size() == 0;
    }

    public HookResult doMail(SMTPSession session, MailAddress sender) {
        if (this.check(session, sender)) {
            return new HookResult(2, "501", DSNStatus.getStatus(5, "1.7") + " sender " + sender + " contains a domain with no valid MX records");
        }
        return new HookResult(8);
    }
}

