/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.UUID;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.ParseException;
import org.apache.james.core.MimeMessageCopyOnWriteProxy;
import org.apache.james.core.MimeMessageInputStreamSource;
import org.apache.james.core.MimeMessageUtil;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;

public class MailImpl
implements Disposable,
Mail {
    public static final long serialVersionUID = -4289663364703986260L;
    private String errorMessage;
    private String state;
    private MimeMessage message;
    private MailAddress sender;
    private Collection recipients;
    private String name;
    private String remoteHost = "localhost";
    private String remoteAddr = "127.0.0.1";
    private Date lastUpdated = new Date();
    private HashMap attributes;
    private static final Random random = new Random();

    public MailImpl() {
        this.setState("root");
        this.attributes = new HashMap();
    }

    public MailImpl(String name, MailAddress sender, Collection recipients) {
        this();
        this.name = name;
        this.sender = sender;
        this.recipients = null;
        if (recipients != null) {
            Iterator theIterator = recipients.iterator();
            this.recipients = new ArrayList();
            while (theIterator.hasNext()) {
                this.recipients.add(theIterator.next());
            }
        }
    }

    public MailImpl(Mail mail) throws MessagingException {
        this(mail, MailImpl.newName(mail));
    }

    public MailImpl(Mail mail, String newName) throws MessagingException {
        this(newName, mail.getSender(), mail.getRecipients(), mail.getMessage());
        this.setRemoteHost(mail.getRemoteHost());
        this.setRemoteAddr(mail.getRemoteAddr());
        this.setLastUpdated(mail.getLastUpdated());
        try {
            if (mail instanceof MailImpl) {
                this.setAttributesRaw((HashMap)MailImpl.cloneSerializableObject(((MailImpl)mail).getAttributesRaw()));
            } else {
                HashMap<String, Object> attribs = new HashMap<String, Object>();
                Iterator i = mail.getAttributeNames();
                while (i.hasNext()) {
                    String hashKey = (String)i.next();
                    attribs.put(hashKey, MailImpl.cloneSerializableObject(mail.getAttribute(hashKey)));
                }
                this.setAttributesRaw(attribs);
            }
        }
        catch (IOException e) {
            this.setAttributesRaw(new HashMap());
        }
        catch (ClassNotFoundException e) {
            this.setAttributesRaw(new HashMap());
        }
    }

    public MailImpl(String name, MailAddress sender, Collection recipients, InputStream messageIn) throws MessagingException {
        this(name, sender, recipients);
        MimeMessageInputStreamSource source = new MimeMessageInputStreamSource(name, messageIn);
        try {
            this.setMessage(new MimeMessageCopyOnWriteProxy(source));
        }
        catch (MessagingException e) {
            LifecycleUtil.dispose((Object)source);
            throw e;
        }
    }

    public MailImpl(String name, MailAddress sender, Collection recipients, MimeMessage message) throws MessagingException {
        this(name, sender, recipients);
        this.setMessage(new MimeMessageCopyOnWriteProxy(message));
    }

    public Mail duplicate() {
        return this.duplicate(this.name);
    }

    public Mail duplicate(String newName) {
        try {
            return new MailImpl(this, newName);
        }
        catch (MessagingException messagingException) {
            return null;
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public MimeMessage getMessage() throws MessagingException {
        return this.message;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Collection getRecipients() {
        return this.recipients;
    }

    public MailAddress getSender() {
        return this.sender;
    }

    public String getState() {
        return this.state;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public long getMessageSize() throws MessagingException {
        return MimeMessageUtil.getMessageSize(this.message);
    }

    public void setErrorMessage(String msg) {
        this.errorMessage = msg;
    }

    public void setMessage(MimeMessage message) {
        if (this.message != message) {
            if (this.message != null) {
                LifecycleUtil.dispose((Object)this.message);
            }
            this.message = message;
        }
    }

    public void setRecipients(Collection recipients) {
        this.recipients = recipients;
    }

    public void setSender(MailAddress sender) {
        this.sender = sender;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public void setLastUpdated(Date lastUpdated) {
        if (lastUpdated != null) {
            lastUpdated = new Date(lastUpdated.getTime());
        }
        this.lastUpdated = lastUpdated;
    }

    public void writeMessageTo(OutputStream out) throws IOException, MessagingException {
        if (this.message == null) {
            throw new MessagingException("No message set for this MailImpl.");
        }
        this.message.writeTo(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            Object obj = in.readObject();
            if (obj == null) {
                this.sender = null;
            } else if (obj instanceof String) {
                this.sender = new MailAddress((String)obj);
            } else if (obj instanceof MailAddress) {
                this.sender = (MailAddress)obj;
            }
        }
        catch (ParseException pe) {
            throw new IOException("Error parsing sender address: " + pe.getMessage());
        }
        this.recipients = (Collection)in.readObject();
        this.state = (String)in.readObject();
        this.errorMessage = (String)in.readObject();
        this.name = (String)in.readObject();
        this.remoteHost = (String)in.readObject();
        this.remoteAddr = (String)in.readObject();
        this.setLastUpdated((Date)in.readObject());
        try {
            this.attributes = (HashMap)in.readObject();
        }
        catch (OptionalDataException ode) {
            if (ode.eof) {
                this.attributes = new HashMap();
            }
            throw ode;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.sender);
        out.writeObject(this.recipients);
        out.writeObject(this.state);
        out.writeObject(this.errorMessage);
        out.writeObject(this.name);
        out.writeObject(this.remoteHost);
        out.writeObject(this.remoteAddr);
        out.writeObject(this.lastUpdated);
        out.writeObject(this.attributes);
    }

    public void dispose() {
        LifecycleUtil.dispose((Object)this.message);
        this.message = null;
    }

    public HashMap getAttributesRaw() {
        return this.attributes;
    }

    public void setAttributesRaw(HashMap attr) {
        this.attributes = attr == null ? new HashMap() : attr;
    }

    public Serializable getAttribute(String key) {
        return (Serializable)this.attributes.get(key);
    }

    public Serializable setAttribute(String key, Serializable object) {
        return this.attributes.put(key, object);
    }

    public Serializable removeAttribute(String key) {
        return (Serializable)this.attributes.remove(key);
    }

    public void removeAllAttributes() {
        this.attributes.clear();
    }

    public Iterator getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    private static Object cloneSerializableObject(Object o) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(b);
        out.writeObject(o);
        out.flush();
        out.close();
        ByteArrayInputStream bi = new ByteArrayInputStream(b.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bi);
        Object no = in.readObject();
        return no;
    }

    public static String newName(Mail mail) throws MessagingException {
        String oldName = mail.getName();
        if (oldName.length() > 76) {
            int count = 0;
            int index = 0;
            while ((index = oldName.indexOf(33, index + 1)) >= 0) {
                ++count;
            }
            if (count > 7) {
                throw new MessagingException("Unable to create a new message name: too long. Possible loop in config.xml.");
            }
            oldName = oldName.substring(0, 76);
        }
        StringBuffer nameBuffer = new StringBuffer(64).append(oldName).append("-!").append(random.nextInt(0x100000));
        return nameBuffer.toString();
    }

    public static String getId() {
        StringBuilder idBuffer = new StringBuilder().append("Mail").append(System.currentTimeMillis()).append("-").append(UUID.randomUUID());
        return idBuffer.toString();
    }
}

