/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.util.SharedFileInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.james.core.MimeMessageSource;
import org.apache.james.lifecycle.api.Disposable;

public class MimeMessageInputStreamSource
extends MimeMessageSource
implements Disposable {
    private final List<InputStream> streams = new ArrayList<InputStream>();
    private OutputStream out;
    private File file;
    private String sourceId;

    public MimeMessageInputStreamSource(String key, InputStream in) throws MessagingException {
        OutputStream fout = null;
        try {
            this.file = File.createTempFile(key, ".m64");
            fout = new BufferedOutputStream(new FileOutputStream(this.file));
            IOUtils.copy((InputStream)in, (OutputStream)fout);
            this.sourceId = this.file.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new MessagingException("Unable to retrieve the data: " + ioe.getMessage(), (Exception)ioe);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException ioe) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ioe) {}
            if (this.sourceId == null && this.file != null) {
                this.file.delete();
            }
        }
    }

    public MimeMessageInputStreamSource(String key) throws MessagingException {
        try {
            this.file = File.createTempFile(key, ".m64");
            this.sourceId = this.file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new MessagingException("Unable to get canonical file path: " + e.getMessage(), (Exception)e);
        }
        finally {
            if (this.sourceId == null && this.file != null) {
                this.file.delete();
            }
        }
    }

    @Override
    public String getSourceId() {
        return this.sourceId;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        SharedFileInputStream in = new SharedFileInputStream(this.file);
        this.streams.add((InputStream)in);
        return in;
    }

    @Override
    public long getMessageSize() throws IOException {
        return this.file.length();
    }

    public synchronized OutputStream getWritableOutputStream() throws FileNotFoundException {
        if (this.out == null) {
            this.out = new FileOutputStream(this.file);
        }
        return this.out;
    }

    public void dispose() {
        for (int i = 0; i < this.streams.size(); ++i) {
            IOUtils.closeQuietly((InputStream)this.streams.get(i));
        }
        IOUtils.closeQuietly((OutputStream)this.out);
        this.out = null;
        FileUtils.deleteQuietly((File)this.file);
        this.file = null;
    }
}

