/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import java.util.List;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageMetaData;
import org.apache.james.mailbox.UpdatedFlags;

public interface MailboxListener {
    public void event(Event var1);

    public boolean isClosed();

    public static abstract class Added
    extends MessageEvent {
        public Added(MailboxSession session, MailboxPath path) {
            super(session, path);
        }

        public abstract MessageMetaData getMetaData(long var1);
    }

    public static abstract class FlagsUpdated
    extends MessageEvent {
        public FlagsUpdated(MailboxSession session, MailboxPath path) {
            super(session, path);
        }

        public abstract List<UpdatedFlags> getUpdatedFlags();
    }

    public static abstract class Expunged
    extends MessageEvent {
        public Expunged(MailboxSession session, MailboxPath path) {
            super(session, path);
        }

        public abstract MessageMetaData getMetaData(long var1);
    }

    public static abstract class MessageEvent
    extends Event {
        public MessageEvent(MailboxSession session, MailboxPath path) {
            super(session, path);
        }

        public abstract List<Long> getUids();
    }

    public static abstract class MailboxRenamed
    extends Event {
        public MailboxRenamed(MailboxSession session, MailboxPath path) {
            super(session, path);
        }

        public abstract MailboxPath getNewPath();
    }

    public static class MailboxAdded
    extends Event {
        public MailboxAdded(MailboxSession session, MailboxPath path) {
            super(session, path);
        }
    }

    public static class MailboxDeletion
    extends Event {
        public MailboxDeletion(MailboxSession session, MailboxPath path) {
            super(session, path);
        }
    }

    public static class Event {
        private final MailboxSession session;
        private final MailboxPath path;

        public Event(MailboxSession session, MailboxPath path) {
            this.session = session;
            this.path = path;
        }

        public MailboxSession getSession() {
            return this.session;
        }

        public MailboxPath getMailboxPath() {
            return this.path;
        }
    }
}

