/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.MessageResult;
import org.apache.james.mailbox.SearchQuery;

public interface MessageManager {
    public long getMessageCount(MailboxSession var1) throws MailboxException;

    public boolean isWriteable(MailboxSession var1);

    public boolean isModSeqPermanent(MailboxSession var1);

    public Iterator<Long> search(SearchQuery var1, MailboxSession var2) throws MailboxException;

    public Iterator<Long> expunge(MessageRange var1, MailboxSession var2) throws MailboxException;

    public Map<Long, Flags> setFlags(Flags var1, boolean var2, boolean var3, MessageRange var4, MailboxSession var5) throws MailboxException;

    public long appendMessage(InputStream var1, Date var2, MailboxSession var3, boolean var4, Flags var5) throws MailboxException;

    public Iterator<MessageResult> getMessages(MessageRange var1, MessageResult.FetchGroup var2, MailboxSession var3) throws MailboxException;

    public void getMessages(MessageRange var1, MessageResult.FetchGroup var2, MailboxSession var3, MessageCallback var4) throws MailboxException;

    public MetaData getMetaData(boolean var1, MailboxSession var2, MetaData.FetchGroup var3) throws MailboxException;

    public static interface MetaData {
        public List<Long> getRecent();

        public long countRecent();

        public Flags getPermanentFlags();

        public long getUidValidity();

        public long getUidNext();

        public long getHighestModSeq();

        public long getMessageCount();

        public long getUnseenCount();

        public Long getFirstUnseen();

        public boolean isWriteable();

        public boolean isModSeqPermanent();

        public static enum FetchGroup {
            NO_UNSEEN,
            UNSEEN_COUNT,
            FIRST_UNSEEN,
            NO_COUNT;

        }
    }

    public static interface MessageCallback {
        public void onMessages(Iterator<MessageResult> var1) throws MailboxException;
    }
}

