/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MessageRange {
    private static final int NOT_A_UID = -1;
    private static final int UNLIMITED_BATCH = 0;
    private final Type type;
    private final long uidFrom;
    private final long uidTo;
    private final int batchSize;

    public static MessageRange one(long uid) {
        MessageRange result = new MessageRange(Type.ONE, uid, uid, 0);
        return result;
    }

    public static MessageRange all(int batchSize) {
        MessageRange result = new MessageRange(Type.ALL, -1L, -1L, batchSize);
        return result;
    }

    public static MessageRange all() {
        return MessageRange.all(0);
    }

    public static MessageRange range(long from, long to, int batchSize) {
        MessageRange result;
        if (to == Long.MAX_VALUE || to < from) {
            to = -1L;
            result = MessageRange.from(from);
        } else {
            result = from == to ? MessageRange.one(from) : new MessageRange(Type.RANGE, from, to, batchSize);
        }
        return result;
    }

    public static MessageRange range(long from, long to) {
        return MessageRange.range(from, to, 0);
    }

    public static MessageRange from(long from, int batchSize) {
        MessageRange result = new MessageRange(Type.FROM, from, -1L, batchSize);
        return result;
    }

    public static MessageRange from(long from) {
        return MessageRange.from(from, 0);
    }

    protected MessageRange(Type type, long uidFrom, long uidTo, int batchSize) {
        this.type = type;
        this.uidFrom = uidFrom;
        this.uidTo = uidTo;
        this.batchSize = batchSize;
    }

    public Type getType() {
        return this.type;
    }

    public long getUidFrom() {
        return this.uidFrom;
    }

    public long getUidTo() {
        return this.uidTo;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean includes(long uid) {
        switch (this.type) {
            case ALL: {
                return true;
            }
            case FROM: {
                if (uid > this.getUidFrom()) {
                    return true;
                }
            }
            case RANGE: {
                if (uid >= this.getUidFrom() && uid <= this.getUidTo()) {
                    return true;
                }
            }
            case ONE: {
                if (this.getUidFrom() != uid) break;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "TYPE: " + (Object)((Object)this.type) + " UID: " + this.uidFrom + ":" + this.uidTo + (this.batchSize > 0 ? " BATCH: " + this.batchSize : "");
    }

    public MessageRange getUnlimitedRange() {
        if (this.batchSize == 0) {
            return this;
        }
        return new MessageRange(this.type, this.uidFrom, this.uidTo, 0);
    }

    public static List<MessageRange> toRanges(Collection<Long> uidsCol) {
        ArrayList<MessageRange> ranges = new ArrayList<MessageRange>();
        ArrayList<Long> uids = new ArrayList<Long>(uidsCol);
        Collections.sort(uids);
        long firstUid = 0L;
        int a = 0;
        for (int i = 0; i < uids.size(); ++i) {
            long u = (Long)uids.get(i);
            if (i == 0) {
                firstUid = u;
                if (uids.size() != 1) continue;
                ranges.add(MessageRange.one(firstUid));
                continue;
            }
            if (firstUid + (long)a + 1L != u) {
                ranges.add(MessageRange.range(firstUid, firstUid + (long)a));
                firstUid = u;
                a = 0;
                if (uids.size() > i + 1) continue;
                ranges.add(MessageRange.one(firstUid));
                continue;
            }
            ++a;
            if (uids.size() > i + 1) continue;
            ranges.add(MessageRange.range(firstUid, firstUid + (long)a));
            break;
        }
        return ranges;
    }

    @Deprecated
    public static List<MessageRange> toRanges(List<Long> uidsCol) {
        return MessageRange.toRanges(uidsCol);
    }

    public static enum Type {
        ALL,
        ONE,
        FROM,
        RANGE;

    }
}

