/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.mail.Flags;

public class SearchQuery {
    private final Set<Long> recentMessageUids = new HashSet<Long>();
    private final List<Criterion> criterias = new ArrayList<Criterion>();
    private List<Sort> sorts = new ArrayList<Sort>(Arrays.asList(new Sort(Sort.SortClause.Uid, false)));

    public static final Criterion sizeLessThan(long value) {
        return new SizeCriterion(new NumericOperator(value, NumericComparator.LESS_THAN));
    }

    public static final Criterion sizeGreaterThan(long value) {
        return new SizeCriterion(new NumericOperator(value, NumericComparator.GREATER_THAN));
    }

    public static final Criterion sizeEquals(long value) {
        return new SizeCriterion(new NumericOperator(value, NumericComparator.EQUALS));
    }

    public static final Criterion modSeqLessThan(long value) {
        return new ModSeqCriterion(new NumericOperator(value, NumericComparator.LESS_THAN));
    }

    public static final Criterion modSeqGreaterThan(long value) {
        return new ModSeqCriterion(new NumericOperator(value, NumericComparator.GREATER_THAN));
    }

    public static final Criterion modSeqEquals(long value) {
        return new ModSeqCriterion(new NumericOperator(value, NumericComparator.EQUALS));
    }

    public static final Criterion internalDateAfter(Date date, DateResolution res) {
        return new InternalDateCriterion(new DateOperator(DateComparator.AFTER, date, res));
    }

    public static final Criterion internalDateOn(Date date, DateResolution res) {
        return new InternalDateCriterion(new DateOperator(DateComparator.ON, date, res));
    }

    public static final Criterion internalDateBefore(Date date, DateResolution res) {
        return new InternalDateCriterion(new DateOperator(DateComparator.BEFORE, date, res));
    }

    public static final Criterion headerDateAfter(String headerName, Date date, DateResolution res) {
        return new HeaderCriterion(headerName, new DateOperator(DateComparator.AFTER, date, res));
    }

    public static final Criterion headerDateOn(String headerName, Date date, DateResolution res) {
        return new HeaderCriterion(headerName, new DateOperator(DateComparator.ON, date, res));
    }

    public static final Criterion headerDateBefore(String headerName, Date date, DateResolution res) {
        return new HeaderCriterion(headerName, new DateOperator(DateComparator.BEFORE, date, res));
    }

    public static final Criterion address(AddressType type, String address) {
        return new HeaderCriterion(type.name(), new AddressOperator(address));
    }

    public static final Criterion headerContains(String headerName, String value) {
        if (value == null || value.length() == 0) {
            return SearchQuery.headerExists(headerName);
        }
        return new HeaderCriterion(headerName, new ContainsOperator(value));
    }

    public static final Criterion headerExists(String headerName) {
        return new HeaderCriterion(headerName, ExistsOperator.exists());
    }

    public static final Criterion mailContains(String value) {
        return new TextCriterion(value, Scope.FULL);
    }

    public static final Criterion bodyContains(String value) {
        return new TextCriterion(value, Scope.BODY);
    }

    public static final Criterion uid(NumericRange[] range) {
        return new UidCriterion(range);
    }

    public static final Criterion or(Criterion one, Criterion two) {
        ArrayList<Criterion> criteria = new ArrayList<Criterion>();
        criteria.add(one);
        criteria.add(two);
        return new ConjunctionCriterion(Conjunction.OR, criteria);
    }

    public static final Criterion and(Criterion one, Criterion two) {
        ArrayList<Criterion> criteria = new ArrayList<Criterion>();
        criteria.add(one);
        criteria.add(two);
        return new ConjunctionCriterion(Conjunction.AND, criteria);
    }

    public static final Criterion and(List<Criterion> criteria) {
        return new ConjunctionCriterion(Conjunction.AND, criteria);
    }

    public static final Criterion not(Criterion criterion) {
        ArrayList<Criterion> criteria = new ArrayList<Criterion>();
        criteria.add(criterion);
        return new ConjunctionCriterion(Conjunction.NOR, criteria);
    }

    public static final Criterion flagSet(Flags.Flag flag, boolean isSet) {
        Criterion result = isSet ? SearchQuery.flagIsSet(flag) : SearchQuery.flagIsUnSet(flag);
        return result;
    }

    public static final Criterion flagIsSet(Flags.Flag flag) {
        return new FlagCriterion(flag, BooleanOperator.set());
    }

    public static final Criterion flagIsUnSet(Flags.Flag flag) {
        return new FlagCriterion(flag, BooleanOperator.unset());
    }

    public static final Criterion flagSet(String flag, boolean isSet) {
        Criterion result = isSet ? SearchQuery.flagIsSet(flag) : SearchQuery.flagIsUnSet(flag);
        return result;
    }

    public static final Criterion flagIsSet(String flag) {
        return new CustomFlagCriterion(flag, BooleanOperator.set());
    }

    public static final Criterion flagIsUnSet(String flag) {
        return new CustomFlagCriterion(flag, BooleanOperator.unset());
    }

    public static final Criterion all() {
        return AllCriterion.all();
    }

    public void andCriteria(Criterion crit) {
        this.criterias.add(crit);
    }

    public List<Criterion> getCriterias() {
        return this.criterias;
    }

    public void setSorts(List<Sort> sorts) {
        if (sorts == null || sorts.isEmpty()) {
            throw new IllegalArgumentException("There must be at least one Sort");
        }
        this.sorts = sorts;
    }

    public List<Sort> getSorts() {
        return this.sorts;
    }

    public Set<Long> getRecentMessageUids() {
        return this.recentMessageUids;
    }

    public void addRecentMessageUids(Collection<Long> uids) {
        this.recentMessageUids.addAll(uids);
    }

    public String toString() {
        return "Search:" + this.criterias.toString();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.criterias == null ? 0 : ((Object)this.criterias).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchQuery other = (SearchQuery)obj;
        return !(this.criterias == null ? other.criterias != null : !((Object)this.criterias).equals(other.criterias));
    }

    public static final class InOperator
    implements Operator {
        private final NumericRange[] range;

        public InOperator(NumericRange[] range) {
            this.range = range;
        }

        public NumericRange[] getRange() {
            return this.range;
        }

        public int hashCode() {
            return this.range.length;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InOperator other = (InOperator)obj;
            return Arrays.equals(this.range, other.range);
        }

        public String toString() {
            String TAB = " ";
            StringBuffer retValue = new StringBuffer();
            retValue.append("InOperator ( ").append("range = ").append(Arrays.toString(this.range)).append(" ").append(" )");
            return retValue.toString();
        }
    }

    public static final class DateOperator
    implements HeaderOperator {
        public static final int BEFORE = 1;
        public static final int AFTER = 2;
        public static final int ON = 3;
        private final DateComparator type;
        private final Date date;
        private final DateResolution res;

        public DateOperator(DateComparator type, Date date, DateResolution res) {
            this.type = type;
            this.date = date;
            this.res = res;
        }

        public Date getDate() {
            return this.date;
        }

        public DateResolution getDateResultion() {
            return this.res;
        }

        public DateComparator getType() {
            return this.type;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DateOperator other = (DateOperator)obj;
            if (this.res != other.res) {
                return false;
            }
            return this.type == other.type;
        }

        public String toString() {
            String TAB = " ";
            StringBuffer retValue = new StringBuffer();
            retValue.append("DateOperator ( ").append("date = ").append(this.date.toString()).append(" ").append("res = ").append(this.res.name()).append(" ").append("type = ").append((Object)this.type).append(" ").append(" ").append(" )");
            return retValue.toString();
        }
    }

    public static enum DateComparator {
        BEFORE,
        AFTER,
        ON;

    }

    public static final class NumericOperator
    implements Operator {
        public static final int EQUALS = 1;
        public static final int LESS_THAN = 2;
        public static final int GREATER_THAN = 3;
        private final long value;
        private final NumericComparator type;

        private NumericOperator(long value, NumericComparator type) {
            this.value = value;
            this.type = type;
        }

        public NumericComparator getType() {
            return this.type;
        }

        public long getValue() {
            return this.value;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (int)(this.value ^ this.value >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NumericOperator other = (NumericOperator)obj;
            if (this.type != other.type) {
                return false;
            }
            return this.value == other.value;
        }

        public String toString() {
            String TAB = " ";
            StringBuffer retValue = new StringBuffer();
            retValue.append("NumericOperator ( ").append("type = ").append((Object)this.type).append(" ").append("value = ").append(this.value).append(" ").append(" )");
            return retValue.toString();
        }
    }

    public static enum NumericComparator {
        EQUALS,
        LESS_THAN,
        GREATER_THAN;

    }

    public static final class BooleanOperator
    implements Operator {
        private static final BooleanOperator SET = new BooleanOperator(true);
        private static final BooleanOperator UNSET = new BooleanOperator(false);
        private final boolean set;

        public static BooleanOperator set() {
            return SET;
        }

        public static BooleanOperator unset() {
            return UNSET;
        }

        private BooleanOperator(boolean set) {
            this.set = set;
        }

        public boolean isSet() {
            return this.set;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.set ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BooleanOperator other = (BooleanOperator)obj;
            return this.set == other.set;
        }

        public String toString() {
            String TAB = " ";
            StringBuffer retValue = new StringBuffer();
            retValue.append("BooleanOperator ( ").append("set = ").append(this.set).append(" ").append(" )");
            return retValue.toString();
        }
    }

    public static final class ExistsOperator
    implements HeaderOperator {
        private static final ExistsOperator EXISTS = new ExistsOperator();

        public static ExistsOperator exists() {
            return EXISTS;
        }

        public boolean equals(Object obj) {
            return obj instanceof ExistsOperator;
        }

        public int hashCode() {
            return 42;
        }

        public String toString() {
            return "ExistsCriterion";
        }
    }

    public static final class ContainsOperator
    implements HeaderOperator {
        private final String value;

        public ContainsOperator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContainsOperator other = (ContainsOperator)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            String TAB = " ";
            StringBuffer retValue = new StringBuffer();
            retValue.append("ContainsOperator ( ").append("value = ").append(this.value).append(" ").append(" )");
            return retValue.toString();
        }
    }

    public static final class AddressOperator
    implements HeaderOperator {
        private final String address;

        public AddressOperator(String address) {
            this.address = address;
        }

        public String getAddress() {
            return this.address;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddressOperator other = (AddressOperator)obj;
            return !(this.address == null ? other.address != null : !this.address.equals(other.address));
        }

        public String toString() {
            String TAB = " ";
            StringBuffer retValue = new StringBuffer();
            retValue.append("AdressOperator ( ").append("address = ").append(this.address).append(" ").append(" )");
            return retValue.toString();
        }
    }

    public static interface HeaderOperator
    extends Operator {
    }

    public static interface Operator {
    }

    public static final class UidCriterion
    extends Criterion {
        private final InOperator operator;

        public UidCriterion(NumericRange[] ranges) {
            this.operator = new InOperator(ranges);
        }

        public InOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UidCriterion other = (UidCriterion)obj;
            return !(this.operator == null ? other.operator != null : !this.operator.equals(other.operator));
        }

        public String toString() {
            String TAB = " ";
            StringBuffer retValue = new StringBuffer();
            retValue.append("UidCriterion ( ").append("operator = ").append(this.operator).append(" ").append(" )");
            return retValue.toString();
        }
    }

    public static final class FlagCriterion
    extends Criterion {
        private final Flags.Flag flag;
        private final BooleanOperator operator;

        private FlagCriterion(Flags.Flag flag, BooleanOperator operator) {
            this.flag = flag;
            this.operator = operator;
        }

        public Flags.Flag getFlag() {
            return this.flag;
        }

        public BooleanOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.flag == null ? 0 : this.flag.hashCode());
            result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FlagCriterion other = (FlagCriterion)obj;
            if (this.flag == null ? other.flag != null : !this.flag.equals(other.flag)) {
                return false;
            }
            return !(this.operator == null ? other.operator != null : !this.operator.equals(other.operator));
        }

        public String toString() {
            String TAB = " ";
            StringBuffer retValue = new StringBuffer();
            retValue.append("FlagCriterion ( ").append("flag = ").append(this.flag).append(" ").append("operator = ").append(this.operator).append(" ").append(" )");
            return retValue.toString();
        }
    }

    public static final class CustomFlagCriterion
    extends Criterion {
        private final String flag;
        private final BooleanOperator operator;

        private CustomFlagCriterion(String flag, BooleanOperator operator) {
            this.flag = flag;
            this.operator = operator;
        }

        public String getFlag() {
            return this.flag;
        }

        public BooleanOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.flag == null ? 0 : this.flag.hashCode());
            result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CustomFlagCriterion other = (CustomFlagCriterion)obj;
            if (this.flag == null ? other.flag != null : !this.flag.equals(other.flag)) {
                return false;
            }
            return !(this.operator == null ? other.operator != null : !this.operator.equals(other.operator));
        }

        public String toString() {
            String TAB = " ";
            StringBuffer retValue = new StringBuffer();
            retValue.append("CustomFlagCriterion ( ").append("flag = ").append(this.flag).append(" ").append("operator = ").append(this.operator).append(" ").append(" )");
            return retValue.toString();
        }
    }

    public static final class SizeCriterion
    extends Criterion {
        private final NumericOperator operator;

        private SizeCriterion(NumericOperator operator) {
            this.operator = operator;
        }

        public NumericOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SizeCriterion other = (SizeCriterion)obj;
            return !(this.operator == null ? other.operator != null : !this.operator.equals(other.operator));
        }

        public String toString() {
            String TAB = " ";
            StringBuffer retValue = new StringBuffer();
            retValue.append("SizeCriterion ( ").append("operator = ").append(this.operator).append(" ").append(" )");
            return retValue.toString();
        }
    }

    public static final class ModSeqCriterion
    extends Criterion {
        private final NumericOperator operator;

        private ModSeqCriterion(NumericOperator operator) {
            this.operator = operator;
        }

        public NumericOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModSeqCriterion other = (ModSeqCriterion)obj;
            return !(this.operator == null ? other.operator != null : !this.operator.equals(other.operator));
        }

        public String toString() {
            String TAB = " ";
            StringBuffer retValue = new StringBuffer();
            retValue.append("SizeCriterion ( ").append("operator = ").append(this.operator).append(" ").append(" )");
            return retValue.toString();
        }
    }

    public static final class InternalDateCriterion
    extends Criterion {
        private final DateOperator operator;

        public InternalDateCriterion(DateOperator operator) {
            this.operator = operator;
        }

        public DateOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InternalDateCriterion other = (InternalDateCriterion)obj;
            return !(this.operator == null ? other.operator != null : !this.operator.equals(other.operator));
        }

        public String toString() {
            String TAB = " ";
            StringBuffer retValue = new StringBuffer();
            retValue.append("InternalDateCriterion ( ").append("operator = ").append(this.operator).append(" ").append(" )");
            return retValue.toString();
        }
    }

    public static final class HeaderCriterion
    extends Criterion {
        private final HeaderOperator operator;
        private final String headerName;

        private HeaderCriterion(String headerName, HeaderOperator operator) {
            this.operator = operator;
            this.headerName = headerName;
        }

        public String getHeaderName() {
            return this.headerName;
        }

        public HeaderOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.headerName == null ? 0 : this.headerName.hashCode());
            result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HeaderCriterion other = (HeaderCriterion)obj;
            if (this.headerName == null ? other.headerName != null : !this.headerName.equals(other.headerName)) {
                return false;
            }
            return !(this.operator == null ? other.operator != null : !this.operator.equals(other.operator));
        }

        public String toString() {
            String TAB = " ";
            StringBuffer retValue = new StringBuffer();
            retValue.append("HeaderCriterion ( ").append("headerName = ").append(this.headerName).append(" ").append("operator = ").append(this.operator).append(" ").append(" )");
            return retValue.toString();
        }
    }

    public static final class TextCriterion
    extends Criterion {
        private final Scope type;
        private final ContainsOperator operator;

        private TextCriterion(String value, Scope type) {
            this.operator = new ContainsOperator(value);
            this.type = type;
        }

        public Scope getType() {
            return this.type;
        }

        public ContainsOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TextCriterion other = (TextCriterion)obj;
            if (this.operator == null ? other.operator != null : !this.operator.equals(other.operator)) {
                return false;
            }
            return this.type == other.type;
        }

        public String toString() {
            String TAB = " ";
            StringBuffer retValue = new StringBuffer();
            retValue.append("TextCriterion ( ").append("operator = ").append(this.operator).append(" ").append("type = ").append((Object)this.type).append(" ").append(" )");
            return retValue.toString();
        }
    }

    public static enum Scope {
        BODY,
        FULL;

    }

    public static final class AllCriterion
    extends Criterion {
        private static final AllCriterion ALL = new AllCriterion();

        private static Criterion all() {
            return ALL;
        }

        public boolean equals(Object obj) {
            return obj instanceof AllCriterion;
        }

        public int hashCode() {
            return 1729;
        }

        public String toString() {
            return "AllCriterion";
        }
    }

    public static final class ConjunctionCriterion
    extends Criterion {
        private final Conjunction type;
        private final List<Criterion> criteria;

        public ConjunctionCriterion(Conjunction type, List<Criterion> criteria) {
            this.type = type;
            this.criteria = criteria;
        }

        public List<Criterion> getCriteria() {
            return this.criteria;
        }

        public Conjunction getType() {
            return this.type;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.criteria == null ? 0 : ((Object)this.criteria).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConjunctionCriterion other = (ConjunctionCriterion)obj;
            if (this.criteria == null ? other.criteria != null : !((Object)this.criteria).equals(other.criteria)) {
                return false;
            }
            return this.type == other.type;
        }

        public String toString() {
            String TAB = " ";
            StringBuffer retValue = new StringBuffer();
            retValue.append("ConjunctionCriterion ( ").append("criteria = ").append(this.criteria).append(" ").append("type = ").append((Object)this.type).append(" ").append(" )");
            return retValue.toString();
        }
    }

    public static enum Conjunction {
        AND,
        OR,
        NOR;

    }

    public static abstract class Criterion {
    }

    public static final class NumericRange {
        private final long lowValue;
        private final long highValue;

        public NumericRange(long value) {
            this.lowValue = value;
            this.highValue = value;
        }

        public NumericRange(long lowValue, long highValue) {
            this.lowValue = lowValue;
            this.highValue = highValue;
        }

        public long getHighValue() {
            return this.highValue;
        }

        public long getLowValue() {
            return this.lowValue;
        }

        public boolean isIn(long value) {
            if (this.lowValue == Long.MAX_VALUE) {
                return this.highValue >= value;
            }
            return this.lowValue <= value && this.highValue >= value;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (int)(this.highValue ^ this.highValue >>> 32);
            result = 31 * result + (int)(this.lowValue ^ this.lowValue >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NumericRange other = (NumericRange)obj;
            if (this.highValue != other.highValue) {
                return false;
            }
            return this.lowValue == other.lowValue;
        }

        public String toString() {
            return new StringBuffer().append(this.lowValue).append("->").append(this.highValue).toString();
        }
    }

    public static final class Sort {
        private final boolean reverse;
        private final SortClause sortClause;

        public Sort(SortClause sortClause, boolean reverse) {
            this.reverse = reverse;
            this.sortClause = sortClause;
        }

        public Sort(SortClause sortClause) {
            this(sortClause, false);
        }

        public boolean isReverse() {
            return this.reverse;
        }

        public SortClause getSortClause() {
            return this.sortClause;
        }

        public static enum SortClause {
            Arrival,
            MailboxCc,
            MailboxFrom,
            MailboxTo,
            BaseSubject,
            Size,
            SentDate,
            DisplayFrom,
            DisplayTo,
            Uid;

        }
    }

    public static enum AddressType {
        From,
        To,
        Cc,
        Bcc;

    }

    public static enum DateResolution {
        Second,
        Minute,
        Hour,
        Day,
        Month,
        Year;

    }
}

