/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import java.util.Arrays;
import java.util.Iterator;
import javax.mail.Flags;

public class UpdatedFlags {
    private final long uid;
    private final Flags oldFlags;
    private final Flags newFlags;
    private final Flags modifiedFlags;
    private long modSeq;

    public UpdatedFlags(long uid, long modSeq, Flags oldFlags, Flags newFlags) {
        this.uid = uid;
        this.modSeq = modSeq;
        this.oldFlags = oldFlags;
        this.newFlags = newFlags;
        this.modifiedFlags = new Flags();
        UpdatedFlags.addModifiedSystemFlags(oldFlags, newFlags, this.modifiedFlags);
        UpdatedFlags.addModifiedUserFlags(oldFlags, newFlags, this.modifiedFlags);
    }

    private static void addModifiedSystemFlags(Flags oldFlags, Flags newFlags, Flags modifiedFlags) {
        if (UpdatedFlags.isChanged(oldFlags, newFlags, Flags.Flag.ANSWERED)) {
            modifiedFlags.add(Flags.Flag.ANSWERED);
        }
        if (UpdatedFlags.isChanged(oldFlags, newFlags, Flags.Flag.DELETED)) {
            modifiedFlags.add(Flags.Flag.DELETED);
        }
        if (UpdatedFlags.isChanged(oldFlags, newFlags, Flags.Flag.DRAFT)) {
            modifiedFlags.add(Flags.Flag.DRAFT);
        }
        if (UpdatedFlags.isChanged(oldFlags, newFlags, Flags.Flag.FLAGGED)) {
            modifiedFlags.add(Flags.Flag.FLAGGED);
        }
        if (UpdatedFlags.isChanged(oldFlags, newFlags, Flags.Flag.RECENT)) {
            modifiedFlags.add(Flags.Flag.RECENT);
        }
        if (UpdatedFlags.isChanged(oldFlags, newFlags, Flags.Flag.SEEN)) {
            modifiedFlags.add(Flags.Flag.SEEN);
        }
    }

    private static void addModifiedUserFlags(Flags oldFlags, Flags newFlags, Flags modifiedFlags) {
        UpdatedFlags.addModifiedUserFlags(oldFlags, newFlags, oldFlags.getUserFlags(), modifiedFlags);
        UpdatedFlags.addModifiedUserFlags(oldFlags, newFlags, newFlags.getUserFlags(), modifiedFlags);
    }

    private static void addModifiedUserFlags(Flags oldFlags, Flags newFlags, String[] userflags, Flags modifiedFlags) {
        for (int i = 0; i < userflags.length; ++i) {
            String userFlag = userflags[i];
            if (!UpdatedFlags.isChanged(oldFlags, newFlags, userFlag)) continue;
            modifiedFlags.add(userFlag);
        }
    }

    private static boolean isChanged(Flags original, Flags updated, Flags.Flag flag) {
        return original != null && updated != null && original.contains(flag) ^ updated.contains(flag);
    }

    private static boolean isChanged(Flags original, Flags updated, String userFlag) {
        return original != null && updated != null && original.contains(userFlag) ^ updated.contains(userFlag);
    }

    public Flags getOldFlags() {
        return this.oldFlags;
    }

    public Flags getNewFlags() {
        return this.newFlags;
    }

    public long getUid() {
        return this.uid;
    }

    public Iterator<Flags.Flag> systemFlagIterator() {
        return Arrays.asList(this.modifiedFlags.getSystemFlags()).iterator();
    }

    public Iterator<String> userFlagIterator() {
        return Arrays.asList(this.modifiedFlags.getUserFlags()).iterator();
    }

    public long getModSeq() {
        return this.modSeq;
    }

    public static boolean flagsChanged(Flags flagsOld, Flags flagsNew) {
        Flags modifiedFlags = new Flags();
        UpdatedFlags.addModifiedSystemFlags(flagsOld, flagsNew, modifiedFlags);
        UpdatedFlags.addModifiedUserFlags(flagsOld, flagsNew, modifiedFlags);
        return modifiedFlags.getSystemFlags().length > 0 || modifiedFlags.getUserFlags().length > 0;
    }

    public boolean flagsChanged() {
        return this.modifiedFlags.getSystemFlags().length > 0 || this.modifiedFlags.getUserFlags().length > 0;
    }
}

