/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.BinaryPredicate;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.util.ObjectHelper;

public abstract class BinaryPredicateSupport
implements BinaryPredicate {
    private final Expression left;
    private final Expression right;
    private Object lastLeftValue;
    private Object lastRightValue;

    protected BinaryPredicateSupport(Expression left, Expression right) {
        ObjectHelper.notNull(left, "left");
        ObjectHelper.notNull(right, "right");
        this.left = left;
        this.right = right;
    }

    public String toString() {
        return this.left + " " + this.getOperationText() + " " + this.right;
    }

    public boolean matches(Exchange exchange) {
        Object rightValue;
        Object leftValue = this.left.evaluate(exchange, Object.class);
        this.lastRightValue = rightValue = this.right.evaluate(exchange, Object.class);
        this.lastLeftValue = leftValue;
        return this.matches(exchange, leftValue, rightValue);
    }

    protected abstract boolean matches(Exchange var1, Object var2, Object var3);

    protected abstract String getOperationText();

    public Expression getRight() {
        return this.right;
    }

    public Expression getLeft() {
        return this.left;
    }

    public String getOperator() {
        return this.getOperationText();
    }

    public Object getRightValue() {
        return this.lastRightValue;
    }

    public Object getLeftValue() {
        return this.lastLeftValue;
    }
}

