/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.strategy.MarkerFileExclusiveReadLockStrategy;
import org.apache.camel.util.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileChangedExclusiveReadLockStrategy
extends MarkerFileExclusiveReadLockStrategy {
    private static final transient Log LOG = LogFactory.getLog(FileChangedExclusiveReadLockStrategy.class);
    private long timeout;

    @Override
    public void prepareOnStartup(GenericFileOperations<File> operations, GenericFileEndpoint<File> endpoint) {
    }

    @Override
    public boolean acquireExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        boolean exclusive;
        block9: {
            File target = new File(file.getAbsoluteFilePath());
            exclusive = false;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Waiting for exclusive read lock to file: " + file));
            }
            try {
                long lastModified = Long.MIN_VALUE;
                long length = Long.MIN_VALUE;
                StopWatch watch = new StopWatch();
                while (!exclusive) {
                    long delta;
                    if (this.timeout > 0L && (delta = watch.taken()) > this.timeout) {
                        LOG.warn((Object)("Cannot acquire read lock within " + this.timeout + " millis. Will skip the file: " + file));
                        return false;
                    }
                    long newLastModified = target.lastModified();
                    long newLength = target.length();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Previous last modified: " + lastModified + ", new last modified: " + newLastModified));
                        LOG.trace((Object)("Previous length: " + length + ", new length: " + newLength));
                    }
                    if (newLastModified == lastModified && newLength == length) {
                        exclusive = super.acquireExclusiveReadLock(operations, file, exchange);
                        continue;
                    }
                    lastModified = newLastModified;
                    length = newLength;
                    boolean interrupted = this.sleep();
                    if (!interrupted) continue;
                    return false;
                }
            }
            catch (IOException e) {
                boolean interrupted;
                if (this.timeout == 0L) {
                    throw e;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Cannot acquire read lock. Will try again.", (Throwable)e);
                }
                if (!(interrupted = this.sleep())) break block9;
                return false;
            }
        }
        return exclusive;
    }

    private boolean sleep() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Exclusive read lock not granted. Sleeping for 1000 millis.");
        }
        try {
            Thread.sleep(1000L);
            return false;
        }
        catch (InterruptedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Sleep interrupted while waiting for exclusive read lock, so breaking out");
            }
            return true;
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

