/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.EventObject;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import org.apache.camel.management.EventNotifierSupport;
import org.apache.camel.management.JmxNotificationBroadcasterAware;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmxNotificationEventNotifier
extends EventNotifierSupport
implements JmxNotificationBroadcasterAware {
    private static final transient Log LOG = LogFactory.getLog(JmxNotificationEventNotifier.class);
    private final AtomicLong counter = new AtomicLong();
    private NotificationBroadcasterSupport notificationBroadcaster;
    private String source = "Camel";

    public void setNotificationBroadcaster(NotificationBroadcasterSupport broadcaster) {
        this.notificationBroadcaster = broadcaster;
    }

    public void notify(EventObject event) throws Exception {
        if (this.notificationBroadcaster != null) {
            String type = event.getClass().getSimpleName();
            String message = event.toString();
            Notification notification = new Notification(type, (Object)this.source, this.counter.getAndIncrement(), message);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Broadcasting JMX notification: " + notification));
            }
            this.notificationBroadcaster.sendNotification(notification);
        }
    }

    public boolean isEnabled(EventObject event) {
        return true;
    }

    protected void doStart() throws Exception {
        this.counter.set(0L);
    }

    protected void doStop() throws Exception {
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}

