/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.processor.Throttler;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="throttle")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ThrottleDefinition
extends OutputDefinition<ThrottleDefinition>
implements ExecutorServiceAwareDefinition<ThrottleDefinition> {
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    private Long maximumRequestsPerPeriod;
    @XmlAttribute
    private Long timePeriodMillis;
    @XmlAttribute
    private Boolean asyncDelayed;
    @XmlAttribute
    private Boolean callerRunsWhenRejected;

    public ThrottleDefinition() {
    }

    public ThrottleDefinition(long maximumRequestsPerPeriod) {
        this.maximumRequestsPerPeriod = maximumRequestsPerPeriod;
    }

    public String toString() {
        return "Throttle[" + this.getMaximumRequestsPerPeriod() + " request per " + this.getTimePeriodMillis() + " millis -> " + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "throttle";
    }

    @Override
    public String getLabel() {
        return "" + this.getMaximumRequestsPerPeriod() + " per " + this.getTimePeriodMillis() + " (ms)";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Processor childProcessor = this.createChildProcessor(routeContext, true);
        ScheduledExecutorService scheduled = null;
        if (this.getAsyncDelayed() != null && this.getAsyncDelayed().booleanValue() && (scheduled = ExecutorServiceHelper.getConfiguredScheduledExecutorService(routeContext, "Throttle", this)) == null) {
            scheduled = routeContext.getCamelContext().getExecutorServiceStrategy().newScheduledThreadPool(this, "Throttle");
        }
        long period = this.getTimePeriodMillis() != null ? this.getTimePeriodMillis() : 1000L;
        Throttler answer = new Throttler(childProcessor, this.getMaximumRequestsPerPeriod(), period, scheduled);
        if (this.getAsyncDelayed() != null) {
            answer.setAsyncDelayed(this.getAsyncDelayed());
        }
        if (this.getCallerRunsWhenRejected() == null) {
            answer.setCallerRunsWhenRejected(true);
        } else {
            answer.setCallerRunsWhenRejected(this.getCallerRunsWhenRejected());
        }
        return answer;
    }

    public ThrottleDefinition timePeriodMillis(long timePeriodMillis) {
        this.setTimePeriodMillis(timePeriodMillis);
        return this;
    }

    public ThrottleDefinition maximumRequestsPerPeriod(Long maximumRequestsPerPeriod) {
        this.setMaximumRequestsPerPeriod(maximumRequestsPerPeriod);
        return this;
    }

    public ThrottleDefinition callerRunsWhenRejected(boolean callerRunsWhenRejected) {
        this.setCallerRunsWhenRejected(callerRunsWhenRejected);
        return this;
    }

    public ThrottleDefinition asyncDelayed() {
        this.setAsyncDelayed(true);
        return this;
    }

    @Override
    public ThrottleDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public ThrottleDefinition executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    public Long getMaximumRequestsPerPeriod() {
        return this.maximumRequestsPerPeriod;
    }

    public void setMaximumRequestsPerPeriod(Long maximumRequestsPerPeriod) {
        this.maximumRequestsPerPeriod = maximumRequestsPerPeriod;
    }

    public Long getTimePeriodMillis() {
        return this.timePeriodMillis;
    }

    public void setTimePeriodMillis(Long timePeriodMillis) {
        this.timePeriodMillis = timePeriodMillis;
    }

    public Boolean getAsyncDelayed() {
        return this.asyncDelayed;
    }

    public void setAsyncDelayed(Boolean asyncDelayed) {
        this.asyncDelayed = asyncDelayed;
    }

    public Boolean getCallerRunsWhenRejected() {
        return this.callerRunsWhenRejected;
    }

    public void setCallerRunsWhenRejected(Boolean callerRunsWhenRejected) {
        this.callerRunsWhenRejected = callerRunsWhenRejected;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    @Override
    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }
}

