/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.processor.UnitOfWorkProcessor;
import org.apache.camel.util.ServiceHelper;

public final class UnitOfWorkProducer
implements Producer {
    private final Producer producer;
    private final Processor processor;

    public UnitOfWorkProducer(Producer producer) {
        this.producer = producer;
        this.processor = new UnitOfWorkProcessor(producer);
    }

    public Endpoint getEndpoint() {
        return this.producer.getEndpoint();
    }

    public Exchange createExchange() {
        return this.producer.createExchange();
    }

    public Exchange createExchange(ExchangePattern pattern) {
        return this.producer.createExchange(pattern);
    }

    public Exchange createExchange(Exchange exchange) {
        return this.producer.createExchange(exchange);
    }

    public void process(Exchange exchange) throws Exception {
        this.processor.process(exchange);
    }

    public void start() throws Exception {
        ServiceHelper.startService(this.processor);
    }

    public void stop() throws Exception {
        ServiceHelper.stopService(this.processor);
    }

    public boolean isSingleton() {
        return this.producer.isSingleton();
    }

    public String toString() {
        return "UnitOfWork(" + this.producer + ")";
    }
}

