/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsyncProcessorHelper {
    private static final transient Log LOG = LogFactory.getLog(AsyncProcessorHelper.class);

    private AsyncProcessorHelper() {
    }

    public static boolean process(AsyncProcessor processor, Exchange exchange, AsyncCallback callback) {
        boolean sync;
        if (exchange.isTransacted()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Transacted Exchange must be routed synchronously for exchangeId: " + exchange.getExchangeId() + " -> " + exchange));
            }
            try {
                AsyncProcessorHelper.process(processor, exchange);
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            callback.done(true);
            sync = true;
        } else {
            sync = processor.process(exchange, callback);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Exchange processed and is continued routed " + (sync ? "synchronously" : "asynchronously") + " for exchangeId: " + exchange.getExchangeId() + " -> " + exchange));
        }
        return sync;
    }

    public static void process(final AsyncProcessor processor, final Exchange exchange) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        boolean sync = processor.process(exchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                if (!doneSync) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Asynchronous callback received for exchangeId: " + exchange.getExchangeId()));
                    }
                    latch.countDown();
                }
            }

            public String toString() {
                return "Done " + processor;
            }
        });
        if (!sync) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Waiting for asynchronous callback before continuing for exchangeId: " + exchange.getExchangeId() + " -> " + exchange));
            }
            latch.await();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Asynchronous callback received, will continue routing exchangeId: " + exchange.getExchangeId() + " -> " + exchange));
            }
        }
    }

    @Deprecated
    public static Future<Exchange> asyncProcess(ExecutorService executor, final Processor processor, final Exchange exchange) {
        Callable<Exchange> task = new Callable<Exchange>(){

            @Override
            public Exchange call() throws Exception {
                processor.process(exchange);
                return exchange;
            }
        };
        return executor.submit(task);
    }
}

