/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server;

import java.util.LinkedList;
import java.util.List;
import org.apache.james.protocols.api.RetCodeResponse;

public class POP3Response
implements RetCodeResponse {
    public static final String OK_RESPONSE = "+OK";
    public static final String ERR_RESPONSE = "-ERR";
    private String retCode = null;
    private List<CharSequence> lines = null;
    private String rawLine = null;
    private boolean endSession = false;

    public POP3Response(String code, CharSequence description) {
        if (code == null) {
            throw new IllegalArgumentException("POP3Response code can not be null");
        }
        this.setRetCode(code);
        if (description == null) {
            description = "";
        }
        this.rawLine = code + " " + description;
        this.appendLine(description);
    }

    public POP3Response(String code) {
        this(code, null);
    }

    public void appendLine(CharSequence line) {
        if (this.lines == null) {
            this.lines = new LinkedList<CharSequence>();
        }
        this.lines.add(line);
    }

    public String getRetCode() {
        return this.retCode;
    }

    public void setRetCode(String retCode) {
        this.retCode = retCode;
    }

    public List<CharSequence> getLines() {
        return this.lines;
    }

    public String getRawLine() {
        return this.rawLine;
    }

    public boolean isEndSession() {
        return this.endSession;
    }

    public void setEndSession(boolean endSession) {
        this.endSession = endSession;
    }

    public String toString() {
        return this.getRetCode() + " " + this.getLines();
    }
}

