/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.core;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CRLFTerminatedInputStream
extends FilterInputStream {
    private int last;
    private byte[] extraData;
    private int pos = 0;
    private boolean complete = false;
    private boolean endOfStream = false;

    public CRLFTerminatedInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.endOfStream) {
            int r = this.in.read(b, off, len);
            if (r == -1) {
                this.endOfStream = true;
                this.calculateExtraData();
                return this.fillArray(b, off, len);
            }
            this.last = b[off + r - 1];
            return r;
        }
        return this.fillArray(b, off, len);
    }

    private int fillArray(byte[] b, int off, int len) {
        int a = -1;
        int i = 0;
        if (this.complete) {
            return -1;
        }
        while (i < len) {
            a = this.readNext();
            if (a == -1) {
                this.complete = true;
                break;
            }
            b[off + i++] = (byte)a;
        }
        return i;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read() throws IOException {
        if (!this.endOfStream) {
            int i = super.read();
            if (i == -1) {
                this.endOfStream = true;
                this.calculateExtraData();
                return this.readNext();
            }
            this.last = i;
            return i;
        }
        return this.readNext();
    }

    private void calculateExtraData() {
        if (this.last == 10) {
            this.extraData = null;
        } else if (this.last == 13) {
            this.extraData = new byte[1];
            this.extraData[0] = 10;
        } else {
            this.extraData = new byte[2];
            this.extraData[0] = 13;
            this.extraData[1] = 10;
        }
    }

    private int readNext() {
        if (this.extraData == null || this.extraData.length == this.pos) {
            return -1;
        }
        return this.extraData[this.pos++];
    }
}

