/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.james.pop3server.POP3Response;
import org.apache.james.pop3server.POP3Session;
import org.apache.james.pop3server.core.CapaCapability;
import org.apache.james.protocols.api.CommandHandler;
import org.apache.james.protocols.api.ExtensibleHandler;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.WiringException;

public class CapaCmdHandler
implements CommandHandler<POP3Session>,
ExtensibleHandler,
CapaCapability {
    public static final String COMMAND_NAME = "CAPA";
    private List<CapaCapability> caps;

    public Response onCommand(POP3Session session, Request request) {
        POP3Response response = new POP3Response("+OK", "Capability list follows");
        for (int i = 0; i < this.caps.size(); ++i) {
            List<String> cList = this.caps.get(i).getImplementedCapabilities(session);
            for (int a = 0; a < cList.size(); ++a) {
                response.appendLine(cList.get(a));
            }
        }
        response.appendLine(".");
        return response;
    }

    public List<Class<?>> getMarkerInterfaces() {
        ArrayList mList = new ArrayList();
        mList.add(CapaCapability.class);
        return mList;
    }

    public void wireExtensions(Class interfaceName, List extension) throws WiringException {
        if (interfaceName.equals(CapaCapability.class)) {
            this.caps = extension;
        }
    }

    public Collection<String> getImplCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(COMMAND_NAME);
        return commands;
    }

    @Override
    public List<String> getImplementedCapabilities(POP3Session session) {
        ArrayList<String> cList = new ArrayList<String>();
        cList.add("PIPELINING");
        return cList;
    }
}

