/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.james.pop3server.POP3Response;
import org.apache.james.pop3server.POP3Session;
import org.apache.james.pop3server.core.MessageMetaData;
import org.apache.james.protocols.api.CommandHandler;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;

public class DeleCmdHandler
implements CommandHandler<POP3Session> {
    private static final String COMMAND_NAME = "DELE";

    public Response onCommand(POP3Session session, Request request) {
        POP3Response response;
        block7: {
            response = null;
            if (session.getHandlerState() == 2) {
                int num = 0;
                try {
                    num = Integer.parseInt(request.getArgument());
                }
                catch (Exception e) {
                    response = new POP3Response("-ERR", "Usage: DELE [mail number]");
                    return response;
                }
                try {
                    List uidList = (List)session.getState().get("UID_LIST");
                    List deletedUidList = (List)session.getState().get("DELETED_UID_LIST");
                    Long uid = ((MessageMetaData)uidList.get(num - 1)).getUid();
                    if (deletedUidList.contains(uid)) {
                        StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") already deleted.");
                        response = new POP3Response("-ERR", responseBuffer.toString());
                        break block7;
                    }
                    deletedUidList.add(uid);
                    response = new POP3Response("+OK", "Message deleted");
                }
                catch (IndexOutOfBoundsException iob) {
                    StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                    response = new POP3Response("-ERR", responseBuffer.toString());
                }
            } else {
                response = new POP3Response("-ERR");
            }
        }
        return response;
    }

    public Collection<String> getImplCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(COMMAND_NAME);
        return commands;
    }
}

