/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.james.pop3server.POP3Response;
import org.apache.james.pop3server.POP3Session;
import org.apache.james.pop3server.core.MessageMetaData;
import org.apache.james.protocols.api.CommandHandler;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;

public class ListCmdHandler
implements CommandHandler<POP3Session> {
    public Response onCommand(POP3Session session, Request request) {
        POP3Response response;
        block11: {
            response = null;
            String parameters = request.getArgument();
            List uidList = (List)session.getState().get("UID_LIST");
            List deletedUidList = (List)session.getState().get("DELETED_UID_LIST");
            if (session.getHandlerState() == 2) {
                if (parameters == null) {
                    long size = 0L;
                    int count = 0;
                    ArrayList<MessageMetaData> validResults = new ArrayList<MessageMetaData>();
                    if (!uidList.isEmpty()) {
                        for (int i = 0; i < uidList.size(); ++i) {
                            MessageMetaData data = (MessageMetaData)uidList.get(i);
                            if (deletedUidList.contains(data.getUid())) continue;
                            size += data.getSize();
                            ++count;
                            validResults.add(data);
                        }
                    }
                    StringBuilder responseBuffer = new StringBuilder(32).append(count).append(" ").append(size);
                    response = new POP3Response("+OK", responseBuffer.toString());
                    count = 0;
                    for (int i = 0; i < validResults.size(); ++i) {
                        responseBuffer = new StringBuilder(16).append(i + 1).append(" ").append(((MessageMetaData)validResults.get(i)).getSize());
                        response.appendLine(responseBuffer.toString());
                    }
                    response.appendLine(".");
                } else {
                    int num = 0;
                    try {
                        num = Integer.parseInt(parameters);
                        MessageMetaData data = (MessageMetaData)uidList.get(num - 1);
                        if (!deletedUidList.contains(data.getUid())) {
                            StringBuilder responseBuffer = new StringBuilder(64).append(num).append(" ").append(data.getSize());
                            response = new POP3Response("+OK", responseBuffer.toString());
                            break block11;
                        }
                        StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") already deleted.");
                        response = new POP3Response("-ERR", responseBuffer.toString());
                    }
                    catch (IndexOutOfBoundsException npe) {
                        StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                        response = new POP3Response("-ERR", responseBuffer.toString());
                    }
                    catch (NumberFormatException nfe) {
                        StringBuilder responseBuffer = new StringBuilder(64).append(parameters).append(" is not a valid number");
                        response = new POP3Response("-ERR", responseBuffer.toString());
                    }
                }
            } else {
                response = new POP3Response("-ERR");
            }
        }
        return response;
    }

    public Collection<String> getImplCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("LIST");
        return commands;
    }
}

