/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.core;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.pop3server.POP3Session;
import org.apache.james.pop3server.core.UnknownCmdHandler;
import org.apache.james.protocols.api.AbstractCommandDispatcher;
import org.apache.james.protocols.api.CommandHandler;
import org.apache.james.protocols.api.ProtocolSession;

public class POP3CommandDispatcherLineHandler
extends AbstractCommandDispatcher<POP3Session> {
    private static final String[] mandatoryCommands = new String[]{"USER", "PASS", "LIST"};
    private final CommandHandler<POP3Session> unknownHandler = new UnknownCmdHandler();
    private MailboxManager manager;

    @Resource(name="mailboxmanager")
    public void setMailboxManager(MailboxManager manager) {
        this.manager = manager;
    }

    protected List<String> getMandatoryCommands() {
        return Arrays.asList(mandatoryCommands);
    }

    protected CommandHandler<POP3Session> getUnknownCommandHandler() {
        return this.unknownHandler;
    }

    protected String getUnknownCommandHandlerIdentifier() {
        return "UNKNOWN";
    }

    public boolean onLine(POP3Session session, byte[] line) {
        MailboxSession mSession = (MailboxSession)session.getState().get("MAILBOX_SESSION");
        this.manager.startProcessingRequest(mSession);
        boolean disconnect = super.onLine((ProtocolSession)session, line);
        this.manager.endProcessingRequest(mSession);
        return disconnect;
    }
}

