/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.core;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.james.mailbox.BadCredentialsException;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPath;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.pop3server.POP3Response;
import org.apache.james.pop3server.POP3Session;
import org.apache.james.pop3server.core.RsetCmdHandler;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.lib.POP3BeforeSMTPHelper;

public class PassCmdHandler
extends RsetCmdHandler {
    private static final String COMMAND_NAME = "PASS";
    private MailboxManager mailboxManager;

    @Resource(name="mailboxmanager")
    public void setMailboxManager(MailboxManager manager) {
        this.mailboxManager = manager;
    }

    @Override
    public Response onCommand(POP3Session session, Request request) {
        String parameters = request.getArgument();
        POP3Response response = null;
        if (session.getHandlerState() == 1 && parameters != null) {
            String passArg = parameters;
            try {
                MailboxSession mSession = this.mailboxManager.login(session.getUser(), passArg, session.getLogger());
                this.mailboxManager.startProcessingRequest(mSession);
                MailboxPath mailboxPath = MailboxPath.inbox((MailboxSession)mSession);
                if (!this.mailboxManager.mailboxExists(mailboxPath, mSession)) {
                    this.mailboxManager.createMailbox(mailboxPath, mSession);
                }
                MessageManager mailbox = this.mailboxManager.getMailbox(mailboxPath, mSession);
                session.getState().put("MAILBOX_SESSION", mSession);
                session.setUserMailbox(mailbox);
                this.stat(session);
                POP3BeforeSMTPHelper.addIPAddress((String)session.getRemoteIPAddress());
                StringBuilder responseBuffer = new StringBuilder(64).append("Welcome ").append(session.getUser());
                response = new POP3Response("+OK", responseBuffer.toString());
                session.setHandlerState(2);
            }
            catch (BadCredentialsException e) {
                response = new POP3Response("-ERR", "Authentication failed.");
                session.setHandlerState(0);
            }
            catch (MailboxException e) {
                session.getLogger().error("Unexpected error accessing mailbox for " + session.getUser(), (Throwable)e);
                response = new POP3Response("-ERR", "Unexpected error accessing mailbox");
                session.setHandlerState(0);
            }
        } else {
            response = new POP3Response("-ERR", "Authentication failed.");
            session.setHandlerState(0);
        }
        return response;
    }

    @Override
    public Collection<String> getImplCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(COMMAND_NAME);
        return commands;
    }
}

