/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.pop3server.POP3Response;
import org.apache.james.pop3server.POP3Session;
import org.apache.james.protocols.api.CommandHandler;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;

public class QuitCmdHandler
implements CommandHandler<POP3Session> {
    private static final String COMMAND_NAME = "QUIT";
    protected MailboxManager mailboxManager;

    @Resource(name="mailboxmanager")
    public void setMailboxManager(MailboxManager manager) {
        this.mailboxManager = manager;
    }

    public Response onCommand(POP3Session session, Request request) {
        POP3Response response = null;
        if (session.getHandlerState() == 0 || session.getHandlerState() == 1) {
            response = new POP3Response("+OK", "Apache James POP3 Server signing off.");
            response.setEndSession(true);
            return response;
        }
        MailboxSession mailboxSession = (MailboxSession)session.getState().get("MAILBOX_SESSION");
        List toBeRemoved = (List)session.getState().get("DELETED_UID_LIST");
        try {
            MessageManager mailbox = session.getUserMailbox();
            for (int i = 0; i < toBeRemoved.size(); ++i) {
                MessageRange range = MessageRange.one((long)((Long)toBeRemoved.get(i)));
                mailbox.setFlags(new Flags(Flags.Flag.DELETED), true, false, range, mailboxSession);
                mailbox.expunge(range, mailboxSession);
            }
            response = new POP3Response("+OK", "Apache James POP3 Server signing off.");
        }
        catch (Exception ex) {
            response = new POP3Response("-ERR", "Some deleted messages were not removed");
            session.getLogger().error("Some deleted messages were not removed", (Throwable)ex);
        }
        response.setEndSession(true);
        try {
            this.mailboxManager.logout(mailboxSession, false);
        }
        catch (MailboxException e) {
            // empty catch block
        }
        return response;
    }

    public Collection<String> getImplCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(COMMAND_NAME);
        return commands;
    }
}

