/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.james.mailbox.Content;
import org.apache.james.mailbox.InputStreamContent;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.MessageResult;
import org.apache.james.pop3server.POP3Response;
import org.apache.james.pop3server.POP3Session;
import org.apache.james.pop3server.core.CRLFTerminatedInputStream;
import org.apache.james.pop3server.core.ExtraDotInputStream;
import org.apache.james.pop3server.core.MessageMetaData;
import org.apache.james.protocols.api.CommandHandler;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;

public class RetrCmdHandler
implements CommandHandler<POP3Session> {
    private static final String COMMAND_NAME = "RETR";
    private static final MessageResult.FetchGroup GROUP = new MessageResult.FetchGroup(){

        public int content() {
            return 512;
        }

        public Set<MessageResult.FetchGroup.PartContentDescriptor> getPartContentDescriptors() {
            return null;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response onCommand(POP3Session session, Request request) {
        POP3Response response;
        block15: {
            response = null;
            String parameters = request.getArgument();
            if (session.getHandlerState() == 2) {
                int num = 0;
                try {
                    num = Integer.parseInt(parameters.trim());
                }
                catch (Exception e) {
                    response = new POP3Response("-ERR", "Usage: RETR [mail number]");
                    return response;
                }
                try {
                    List uidList = (List)session.getState().get("UID_LIST");
                    List deletedUidList = (List)session.getState().get("DELETED_UID_LIST");
                    MailboxSession mailboxSession = (MailboxSession)session.getState().get("MAILBOX_SESSION");
                    Long uid = ((MessageMetaData)uidList.get(num - 1)).getUid();
                    if (!deletedUidList.contains(uid)) {
                        Iterator results = session.getUserMailbox().getMessages(MessageRange.one((long)uid), GROUP, mailboxSession);
                        if (results.hasNext()) {
                            MessageResult result = (MessageResult)results.next();
                            try {
                                session.writeStream(new ByteArrayInputStream("+OK Message follows\r\n".getBytes()));
                                Content content = result.getFullContent();
                                InputStream in = content instanceof InputStreamContent ? ((InputStreamContent)content).getInputStream() : this.createInputStream(content);
                                session.writeStream(new CRLFTerminatedInputStream(new ExtraDotInputStream(in)));
                            }
                            finally {
                                session.writeStream(new ByteArrayInputStream(".\r\n".getBytes()));
                            }
                            return null;
                        }
                        StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                        response = new POP3Response("-ERR", responseBuffer.toString());
                        break block15;
                    }
                    StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") already deleted.");
                    response = new POP3Response("-ERR", responseBuffer.toString());
                }
                catch (IOException ioe) {
                    response = new POP3Response("-ERR", "Error while retrieving message.");
                }
                catch (MailboxException me) {
                    response = new POP3Response("-ERR", "Error while retrieving message.");
                }
                catch (IndexOutOfBoundsException iob) {
                    StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                    response = new POP3Response("-ERR", responseBuffer.toString());
                }
                catch (NoSuchElementException e) {
                    StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                    response = new POP3Response("-ERR", responseBuffer.toString());
                }
            } else {
                response = new POP3Response("-ERR");
            }
        }
        return response;
    }

    protected InputStream createInputStream(Content content) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        content.writeTo(Channels.newChannel(out));
        return new ByteArrayInputStream(out.toByteArray());
    }

    public Collection<String> getImplCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(COMMAND_NAME);
        return commands;
    }
}

