/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.MessageResult;
import org.apache.james.pop3server.POP3Response;
import org.apache.james.pop3server.POP3Session;
import org.apache.james.pop3server.core.MessageMetaData;
import org.apache.james.protocols.api.CommandHandler;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;

public class RsetCmdHandler
implements CommandHandler<POP3Session> {
    private static final String COMMAND_NAME = "RSET";
    private static final MessageResult.FetchGroup GROUP = new MessageResult.FetchGroup(){

        public int content() {
            return 0;
        }

        public Set<MessageResult.FetchGroup.PartContentDescriptor> getPartContentDescriptors() {
            return null;
        }
    };

    public Response onCommand(POP3Session session, Request request) {
        POP3Response response = null;
        if (session.getHandlerState() == 2) {
            this.stat(session);
            response = new POP3Response("+OK");
        } else {
            response = new POP3Response("-ERR");
        }
        return response;
    }

    protected void stat(POP3Session session) {
        try {
            MailboxSession mailboxSession = (MailboxSession)session.getState().get("MAILBOX_SESSION");
            ArrayList<MessageMetaData> uids = new ArrayList<MessageMetaData>();
            Iterator it = session.getUserMailbox().getMessages(MessageRange.all(), GROUP, mailboxSession);
            while (it.hasNext()) {
                MessageResult result = (MessageResult)it.next();
                uids.add(new MessageMetaData(result.getUid(), result.getSize()));
            }
            session.getState().put("UID_LIST", uids);
            session.getState().put("DELETED_UID_LIST", new ArrayList());
        }
        catch (MailboxException e) {
            session.getLogger().error("Unable to STAT mail box ", (Throwable)e);
        }
    }

    public Collection<String> getImplCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(COMMAND_NAME);
        return commands;
    }
}

