/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.james.pop3server.POP3Response;
import org.apache.james.pop3server.POP3Session;
import org.apache.james.pop3server.core.MessageMetaData;
import org.apache.james.protocols.api.CommandHandler;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;

public class StatCmdHandler
implements CommandHandler<POP3Session> {
    private static final String COMMAND_NAME = "STAT";

    public Response onCommand(POP3Session session, Request request) {
        POP3Response response = null;
        if (session.getHandlerState() == 2) {
            List uidList = (List)session.getState().get("UID_LIST");
            List deletedUidList = (List)session.getState().get("DELETED_UID_LIST");
            long size = 0L;
            int count = 0;
            if (!uidList.isEmpty()) {
                ArrayList<MessageMetaData> validResults = new ArrayList<MessageMetaData>();
                for (int i = 0; i < uidList.size(); ++i) {
                    MessageMetaData data = (MessageMetaData)uidList.get(i);
                    if (deletedUidList.contains(data.getUid())) continue;
                    size += data.getSize();
                    ++count;
                    validResults.add(data);
                }
            }
            StringBuilder responseBuffer = new StringBuilder(32).append(count).append(" ").append(size);
            response = new POP3Response("+OK", responseBuffer.toString());
        } else {
            response = new POP3Response("-ERR");
        }
        return response;
    }

    public Collection<String> getImplCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(COMMAND_NAME);
        return commands;
    }
}

