/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.james.pop3server.POP3Response;
import org.apache.james.pop3server.POP3Session;
import org.apache.james.pop3server.core.CapaCapability;
import org.apache.james.protocols.api.CommandHandler;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;

public class StlsCmdHandler
implements CommandHandler<POP3Session>,
CapaCapability {
    public static final String COMMAND_NAME = "STLS";

    public Response onCommand(POP3Session session, Request request) {
        if (session.isStartTLSSupported() && session.getHandlerState() == 0 && !session.isTLSStarted()) {
            POP3Response response = new POP3Response("+OK", "Begin TLS negotiation");
            session.writeResponse((Response)response);
            try {
                session.startTLS();
            }
            catch (IOException e) {
                session.getLogger().info("Error while trying to secure connection", (Throwable)e);
                response = new POP3Response("-ERR");
                response.setEndSession(true);
                return response;
            }
        } else {
            POP3Response response = new POP3Response("-ERR");
            return response;
        }
        return null;
    }

    @Override
    public List<String> getImplementedCapabilities(POP3Session session) {
        ArrayList<String> caps = new ArrayList<String>();
        if (session.isStartTLSSupported() && session.getHandlerState() == 0) {
            caps.add(COMMAND_NAME);
            return caps;
        }
        return caps;
    }

    public Collection<String> getImplCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(COMMAND_NAME);
        return commands;
    }
}

