/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.james.mailbox.Content;
import org.apache.james.mailbox.InputStreamContent;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageRange;
import org.apache.james.mailbox.MessageResult;
import org.apache.james.pop3server.POP3Response;
import org.apache.james.pop3server.POP3Session;
import org.apache.james.pop3server.core.CRLFTerminatedInputStream;
import org.apache.james.pop3server.core.CapaCapability;
import org.apache.james.pop3server.core.ExtraDotInputStream;
import org.apache.james.pop3server.core.MessageMetaData;
import org.apache.james.pop3server.core.RetrCmdHandler;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;

public class TopCmdHandler
extends RetrCmdHandler
implements CapaCapability {
    private static final String COMMAND_NAME = "TOP";
    private static final MessageResult.FetchGroup GROUP = new MessageResult.FetchGroup(){

        public int content() {
            return 1280;
        }

        public Set<MessageResult.FetchGroup.PartContentDescriptor> getPartContentDescriptors() {
            return null;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response onCommand(POP3Session session, Request request) {
        POP3Response response;
        block18: {
            response = null;
            String parameters = request.getArgument();
            if (parameters == null) {
                response = new POP3Response("-ERR", "Usage: TOP [mail number] [Line number]");
                return response;
            }
            String argument = "";
            String argument1 = "";
            int pos = parameters.indexOf(" ");
            if (pos > 0) {
                argument = parameters.substring(0, pos);
                argument1 = parameters.substring(pos + 1);
            }
            if (session.getHandlerState() == 2) {
                int num = 0;
                int lines = -1;
                try {
                    num = Integer.parseInt(argument);
                    lines = Integer.parseInt(argument1);
                }
                catch (NumberFormatException nfe) {
                    response = new POP3Response("-ERR", "Usage: TOP [mail number] [Line number]");
                    return response;
                }
                try {
                    List uidList = (List)session.getState().get("UID_LIST");
                    List deletedUidList = (List)session.getState().get("DELETED_UID_LIST");
                    MailboxSession mailboxSession = (MailboxSession)session.getState().get("MAILBOX_SESSION");
                    Long uid = ((MessageMetaData)uidList.get(num - 1)).getUid();
                    if (!deletedUidList.contains(uid)) {
                        Iterator results = session.getUserMailbox().getMessages(MessageRange.one((long)uid), GROUP, mailboxSession);
                        if (results.hasNext()) {
                            MessageResult result = (MessageResult)results.next();
                            session.writeStream(new ByteArrayInputStream("+OK Message follows\r\n".getBytes()));
                            try {
                                ByteArrayOutputStream headersOut = new ByteArrayOutputStream();
                                WritableByteChannel headersChannel = Channels.newChannel(headersOut);
                                Iterator headers = result.headers();
                                while (headers.hasNext()) {
                                    ((MessageResult.Header)headers.next()).writeTo(headersChannel);
                                    headersChannel.write(ByteBuffer.wrap("\r\n".getBytes()));
                                }
                                headersChannel.write(ByteBuffer.wrap("\r\n".getBytes()));
                                session.writeStream(new ByteArrayInputStream(headersOut.toByteArray()));
                                Content content = result.getBody();
                                InputStream bodyIn = content instanceof InputStreamContent ? ((InputStreamContent)content).getInputStream() : this.createInputStream(content);
                                session.writeStream(new CountingBodyInputStream(new ExtraDotInputStream(new CRLFTerminatedInputStream(bodyIn)), lines));
                            }
                            finally {
                                session.writeStream(new ByteArrayInputStream(".\r\n".getBytes()));
                            }
                            return null;
                        }
                        StringBuilder exceptionBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                        response = new POP3Response("-ERR", exceptionBuffer.toString());
                        break block18;
                    }
                    StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") already deleted.");
                    response = new POP3Response("-ERR", responseBuffer.toString());
                }
                catch (IOException ioe) {
                    response = new POP3Response("-ERR", "Error while retrieving message.");
                }
                catch (MailboxException me) {
                    response = new POP3Response("-ERR", "Error while retrieving message.");
                }
                catch (IndexOutOfBoundsException iob) {
                    StringBuilder exceptionBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                    response = new POP3Response("-ERR", exceptionBuffer.toString());
                }
                catch (NoSuchElementException iob) {
                    StringBuilder exceptionBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                    response = new POP3Response("-ERR", exceptionBuffer.toString());
                }
            } else {
                response = new POP3Response("-ERR");
            }
        }
        return response;
    }

    @Override
    public List<String> getImplementedCapabilities(POP3Session session) {
        ArrayList<String> caps = new ArrayList<String>();
        if (session.getHandlerState() == 2) {
            caps.add(COMMAND_NAME);
            return caps;
        }
        return caps;
    }

    @Override
    public Collection<String> getImplCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(COMMAND_NAME);
        return commands;
    }

    private final class CountingBodyInputStream
    extends FilterInputStream {
        private int count;
        private int limit;
        private int lastChar;

        public CountingBodyInputStream(InputStream in, int limit) {
            super(in);
            this.count = 0;
            this.limit = -1;
            this.limit = limit;
        }

        @Override
        public int read() throws IOException {
            if (this.limit != -1) {
                if (this.count <= this.limit) {
                    int a = this.in.read();
                    if (this.lastChar == 13 && a == 10) {
                        ++this.count;
                    }
                    this.lastChar = a;
                    return a;
                }
                return -1;
            }
            return this.in.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int i;
            if (this.limit == -1) {
                return this.in.read(b, off, len);
            }
            for (i = 0; i < len; ++i) {
                int a = this.read();
                if (i == 0 && a == -1) {
                    return -1;
                }
                if (a == -1) break;
                b[off++] = (byte)a;
            }
            return i;
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (this.limit == -1) {
                return this.in.read(b);
            }
            return this.read(b, 0, b.length);
        }
    }
}

