/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.james.mailbox.MailboxException;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.pop3server.POP3Response;
import org.apache.james.pop3server.POP3Session;
import org.apache.james.pop3server.core.CapaCapability;
import org.apache.james.pop3server.core.MessageMetaData;
import org.apache.james.protocols.api.CommandHandler;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;

public class UidlCmdHandler
implements CommandHandler<POP3Session>,
CapaCapability {
    private static final String COMMAND_NAME = "UIDL";

    public Response onCommand(POP3Session session, Request request) {
        POP3Response response = null;
        String parameters = request.getArgument();
        if (session.getHandlerState() == 2) {
            List uidList = (List)session.getState().get("UID_LIST");
            List deletedUidList = (List)session.getState().get("DELETED_UID_LIST");
            MailboxSession mailboxSession = (MailboxSession)session.getState().get("MAILBOX_SESSION");
            try {
                MessageManager.MetaData mData = session.getUserMailbox().getMetaData(false, mailboxSession, MessageManager.MetaData.FetchGroup.NO_COUNT);
                long validity = mData.getUidValidity();
                if (parameters == null) {
                    response = new POP3Response("+OK", "unique-id listing follows");
                    for (int i = 0; i < uidList.size(); ++i) {
                        Long uid = ((MessageMetaData)uidList.get(i)).getUid();
                        if (deletedUidList.contains(uid)) continue;
                        StringBuilder responseBuffer = new StringBuilder(64).append(i + 1).append(" ").append(validity).append("-").append(uid);
                        response.appendLine(responseBuffer.toString());
                    }
                    response.appendLine(".");
                }
                int num = 0;
                try {
                    num = Integer.parseInt(parameters);
                    Long uid = ((MessageMetaData)uidList.get(num - 1)).getUid();
                    if (!deletedUidList.contains(uid)) {
                        StringBuilder responseBuffer = new StringBuilder(64).append(num).append(" ").append(validity).append("-").append(uid);
                        response = new POP3Response("+OK", responseBuffer.toString());
                    }
                    StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") already deleted.");
                    response = new POP3Response("-ERR", responseBuffer.toString());
                }
                catch (IndexOutOfBoundsException npe) {
                    StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                    response = new POP3Response("-ERR", responseBuffer.toString());
                }
                catch (NumberFormatException nfe) {
                    StringBuilder responseBuffer = new StringBuilder(64).append(parameters).append(" is not a valid number");
                    response = new POP3Response("-ERR", responseBuffer.toString());
                }
            }
            catch (MailboxException e) {
                response = new POP3Response("-ERR");
                return response;
            }
        } else {
            response = new POP3Response("-ERR");
        }
        return response;
    }

    @Override
    public List<String> getImplementedCapabilities(POP3Session session) {
        ArrayList<String> caps = new ArrayList<String>();
        if (session.getHandlerState() == 2) {
            caps.add(COMMAND_NAME);
            return caps;
        }
        return caps;
    }

    public Collection<String> getImplCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(COMMAND_NAME);
        return commands;
    }
}

