/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.netty;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.james.pop3server.POP3HandlerConfigurationData;
import org.apache.james.pop3server.netty.POP3NettySession;
import org.apache.james.protocols.api.ProtocolHandlerChain;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.impl.AbstractChannelUpstreamHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.slf4j.Logger;

public class POP3ChannelUpstreamHandler
extends AbstractChannelUpstreamHandler {
    private final Logger logger;
    private final POP3HandlerConfigurationData conf;
    private final SSLContext context;
    private String[] enabledCipherSuites;

    public POP3ChannelUpstreamHandler(ProtocolHandlerChain chain, POP3HandlerConfigurationData conf, Logger logger, SSLContext context, String[] enabledCipherSuites) {
        super(chain);
        this.logger = logger;
        this.conf = conf;
        this.context = context;
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public POP3ChannelUpstreamHandler(ProtocolHandlerChain chain, POP3HandlerConfigurationData conf, Logger logger) {
        this(chain, conf, logger, null, null);
    }

    protected ProtocolSession createSession(ChannelHandlerContext ctx) throws Exception {
        if (this.context != null) {
            SSLEngine engine = this.context.createSSLEngine();
            if (this.enabledCipherSuites != null && this.enabledCipherSuites.length > 0) {
                engine.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            return new POP3NettySession(this.conf, this.logger, ctx, engine);
        }
        return new POP3NettySession(this.conf, this.logger, ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Object obj = attributes.get(ctx.getChannel());
        if (obj != null) {
            ((POP3NettySession)obj).getLogger().debug("Unable to process pop3 request", e.getCause());
        } else {
            this.logger.debug("Unable to process pop3 request", e.getCause());
        }
        super.exceptionCaught(ctx, e);
    }
}

